/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api.model;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.model.EntityUpdater;
import tocraft.walkers.api.model.impl.AbstractHorseEntityUpdater;
import tocraft.walkers.api.model.impl.ShulkerEntityUpdater;
import tocraft.walkers.api.model.impl.SquidEntityUpdater;
import tocraft.walkers.impl.NearbySongAccessor;
import tocraft.walkers.mixin.accessor.AllayAccessor;
import tocraft.walkers.mixin.accessor.BatAccessor;
import tocraft.walkers.mixin.accessor.CreeperEntityAccessor;
import tocraft.walkers.mixin.accessor.ParrotEntityAccessor;

@OnlyIn(value=Dist.CLIENT)
public class EntityUpdaters {
    private static final Map<EntityType<? extends LivingEntity>, EntityUpdater<? extends LivingEntity>> map = new LinkedHashMap<EntityType<? extends LivingEntity>, EntityUpdater<? extends LivingEntity>>();

    public static <T extends LivingEntity> EntityUpdater<T> getUpdater(EntityType<T> entityType) {
        return map.getOrDefault(entityType, null);
    }

    public static <T extends LivingEntity> void register(EntityType<T> type, EntityUpdater<T> entityUpdater) {
        map.put(type, entityUpdater);
    }

    public static void init() {
        EntityUpdaters.register(EntityType.HORSE, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(EntityType.DONKEY, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(EntityType.MULE, new AbstractHorseEntityUpdater());
        EntityUpdaters.register(EntityType.ALLAY, (player, allay) -> {
            ((AllayAccessor)allay).setHoldingItemAnimationTicks0(((AllayAccessor)allay).getHoldingItemAnimationTicks());
            if (allay.hasItemInHand()) {
                ((AllayAccessor)allay).setHoldingItemAnimationTicks(Mth.clamp((float)(((AllayAccessor)allay).getHoldingItemAnimationTicks() + 1.0f), (float)0.0f, (float)5.0f));
            } else {
                ((AllayAccessor)allay).setHoldingItemAnimationTicks(Mth.clamp((float)(((AllayAccessor)allay).getHoldingItemAnimationTicks() - 1.0f), (float)0.0f, (float)5.0f));
            }
        });
        EntityUpdaters.register(EntityType.BAT, (player, bat) -> {
            bat.setResting(!CEntity.level((Entity)player).getBlockState(player.blockPosition().above()).isAir());
            ((BatAccessor)bat).callSetupAnimationStates();
        });
        EntityUpdaters.register(EntityType.PARROT, (player, parrot) -> {
            parrot.setRecordPlayingNearby(player.blockPosition(), ((NearbySongAccessor)player).shape_isNearbySongPlaying());
            ((ParrotEntityAccessor)parrot).callCalculateFlapping();
            if (player.getRandom().nextInt(400) == 0) {
                Parrot.imitateNearbyMobs((Level)CEntity.level((Entity)player), (Entity)player);
            }
        });
        EntityUpdaters.register(EntityType.ENDER_DRAGON, (player, dragon) -> {
            dragon.flapTime += 0.01f;
            dragon.oFlapTime = dragon.flapTime;
            if (dragon.posPointer < 0) {
                for (int l = 0; l < dragon.positions.length; ++l) {
                    dragon.positions[l][0] = (double)player.getYRot() + 180.0;
                    dragon.positions[l][1] = player.getY();
                }
            }
            if (++dragon.posPointer == dragon.positions.length) {
                dragon.posPointer = 0;
            }
            dragon.positions[dragon.posPointer][0] = (double)player.getYRot() + 180.0;
            dragon.positions[dragon.posPointer][1] = player.getY();
        });
        EntityUpdaters.register(EntityType.ENDERMAN, (player, enderman) -> {
            ItemStack heldStack = player.getMainHandItem();
            if (heldStack.getItem() instanceof BlockItem) {
                enderman.setCarriedBlock(((BlockItem)heldStack.getItem()).getBlock().defaultBlockState());
            }
        });
        EntityUpdaters.register(EntityType.CREEPER, (player, creeper) -> ((CreeperEntityAccessor)creeper).setSwell(0));
        EntityUpdaters.register(EntityType.SQUID, new SquidEntityUpdater());
        EntityUpdaters.register(EntityType.GLOW_SQUID, new SquidEntityUpdater());
        EntityUpdaters.register(EntityType.SHULKER, new ShulkerEntityUpdater());
        EntityUpdaters.register(EntityType.CHICKEN, (player, chicken) -> {
            chicken.oFlap = chicken.flap;
            chicken.oFlapSpeed = chicken.flapSpeed;
            chicken.flapSpeed = chicken.flapSpeed + (CEntity.isOnGround((Entity)player) ? -1.0f : 4.0f) * 0.3f;
            chicken.flapSpeed = Mth.clamp((float)chicken.flapSpeed, (float)0.0f, (float)1.0f);
            if (!CEntity.isOnGround((Entity)player) && chicken.flapping < 1.0f) {
                chicken.flapping = 1.0f;
            }
            chicken.flapping *= 0.9f;
            chicken.flap += chicken.flapping * 2.0f;
        });
        EntityUpdaters.register(EntityType.STRIDER, (player, strider) -> {
            BlockState blockState = CEntity.level((Entity)player).getBlockState(player.blockPosition());
            boolean bl = blockState.is(BlockTags.STRIDER_WARM_BLOCKS) || player.getFluidHeight(FluidTags.LAVA) > 0.0;
            strider.setSuffocating(!bl);
        });
        EntityUpdaters.register(EntityType.CAT, (player, cat) -> cat.setInSittingPose(false));
    }
}

