/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.api;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.walkers.api.blacklist.EntityBlacklist;
import tocraft.walkers.api.events.ShapeEvents;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.NetworkHandler;

public class PlayerShape {
    @Nullable
    public static LivingEntity getCurrentShape(Player player) {
        return ((PlayerDataProvider)player).walkers$getCurrentShape();
    }

    public static boolean updateShapes(ServerPlayer player, @Nullable LivingEntity entity) {
        if (entity != null && EntityBlacklist.isBlacklisted(entity.getType())) {
            return false;
        }
        InteractionResult result = ((ShapeEvents.ShapeSwapCallback)ShapeEvents.SWAP_SHAPE.invoke()).swap(player, entity);
        if (result == InteractionResult.FAIL) {
            return false;
        }
        ((PlayerDataProvider)player).walkers$updateShapes(entity);
        return true;
    }

    @ApiStatus.Internal
    public static void sync(ServerPlayer player) {
        PlayerShape.sync(player, player);
    }

    @ApiStatus.Internal
    public static void sync(ServerPlayer changed, ServerPlayer packetTarget) {
        CompoundTag data = new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        LivingEntity shape = PlayerShape.getCurrentShape((Player)changed);
        if (shape != null) {
            shape.saveWithoutId(entityTag);
        }
        data.putUUID("uuid", changed.getUUID());
        data.putString("type", shape == null ? "minecraft:empty" : EntityType.getKey((EntityType)shape.getType()).toString());
        data.put("entity_tag", (Tag)entityTag);
        ModernNetworking.sendToPlayer((ServerPlayer)packetTarget, (ResourceLocation)NetworkHandler.SHAPE_SYNC, (CompoundTag)data);
    }
}

