/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.specific;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EvokerFangs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import tocraft.craftedcore.patched.CBlockPos;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.ShapeAbility;

public class EvokerAbility<T extends LivingEntity>
extends ShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("evoker");

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public void onUse(Player player, T shape, Level world) {
        if (player.isCrouching() && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            int i = 0;
            for (Entity entity : serverLevel.getAllEntities()) {
                if (entity instanceof Vex && player.distanceTo(entity) <= 16.0f) {
                    ++i;
                }
                if (i < 8) continue;
                return;
            }
            for (int j = 0; j <= 2; ++j) {
                Vex vex = new Vex(EntityType.VEX, world);
                vex.setPos(player.position());
                world.addFreshEntity((Entity)vex);
            }
        } else {
            Vec3 origin = player.position();
            Vec3 facing = player.getLookAngle().multiply(1.0, 0.0, 1.0);
            for (int blockOut = 0; blockOut < 8; ++blockOut) {
                origin = origin.add(facing);
                EvokerFangs fangs = new EvokerFangs(world, origin.x(), origin.y(), origin.z(), player.getYRot(), blockOut * 2, (LivingEntity)player);
                BlockPos underneathPosition = CBlockPos.containing((Vec3)origin).below();
                BlockState underneath = world.getBlockState(underneathPosition);
                if (underneath.isFaceSturdy((BlockGetter)world, underneathPosition, Direction.UP) && world.isEmptyBlock(underneathPosition.above())) {
                    world.addFreshEntity((Entity)fangs);
                    continue;
                }
                BlockPos underneath2Position = CBlockPos.containing((Vec3)origin).below(2);
                BlockState underneath2 = world.getBlockState(underneath2Position);
                if (underneath2.isFaceSturdy((BlockGetter)world, underneath2Position, Direction.UP) && world.isEmptyBlock(underneath2Position.above())) {
                    fangs.setPosRaw(fangs.getX(), fangs.getY() - 1.0, fangs.getZ());
                    world.addFreshEntity((Entity)fangs);
                    origin = origin.add(0.0, -1.0, 0.0);
                    continue;
                }
                BlockPos upPosition = CBlockPos.containing((Vec3)origin).above();
                BlockState up = world.getBlockState(underneath2Position);
                if (up.isFaceSturdy((BlockGetter)world, upPosition, Direction.UP) && world.isEmptyBlock(upPosition)) {
                    fangs.setPosRaw(fangs.getX(), fangs.getY() + 1.0, fangs.getZ());
                    world.addFreshEntity((Entity)fangs);
                    origin = origin.add(0.0, 1.0, 0.0);
                    continue;
                }
                break;
            }
        }
    }

    @Override
    public Item getIcon() {
        return Items.EMERALD;
    }

    @Override
    public int getDefaultCooldown() {
        return 10;
    }
}

