/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability.impl.generic;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

public class RandomTeleportationAbility<T extends LivingEntity>
extends GenericShapeAbility<T> {
    public static final ResourceLocation ID = Walkers.id("random_teleportation");
    public static final MapCodec<RandomTeleportationAbility<?>> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.stable(new RandomTeleportationAbility()));

    @Override
    public ResourceLocation getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }

    @Override
    public void onUse(Player player, T shape, Level world) {
        double x = player.getX();
        double y = player.getY();
        double z = player.getZ();
        for (int i = 0; i < 16; ++i) {
            double g = player.getX() + (player.getRandom().nextDouble() - 0.5) * 16.0;
            double h = Mth.clamp((double)(player.getY() + (double)(player.getRandom().nextInt(16) - 8)), (double)0.0, (double)(world.getHeight() - 1));
            double j = player.getZ() + (player.getRandom().nextDouble() - 0.5) * 16.0;
            if (player.isPassenger()) {
                player.stopRiding();
            }
            if (!player.randomTeleport(g, h, j, true)) continue;
            SoundEvent soundEvent = SoundEvents.CHORUS_FRUIT_TELEPORT;
            world.playSound(null, x, y, z, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
            player.playSound(soundEvent, 1.0f, 1.0f);
            break;
        }
    }

    @Override
    public Item getIcon() {
        return Items.CHORUS_FRUIT;
    }
}

