/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.borninchaosv.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LifestealerSkullBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<AttachFace> FACE = FaceAttachedHorizontalDirectionalBlock.FACE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public LifestealerSkullBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.BONE_BLOCK).strength(5.0f, 80.0f).lightLevel(s -> 3).noOcclusion().hasPostProcess((bs, br, bp) -> true).emissiveRendering((bs, br, bp) -> true).isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return state.getFluidState().isEmpty();
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)1.3, (double)0.23056, (double)-0.333, (double)14.7, (double)12.63056, (double)13.067), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)1.5, (double)0.33056, (double)-0.233, (double)14.5, (double)12.33056, (double)12.767), LifestealerSkullBlock.box((double)4.2, (double)-1.36944, (double)9.467, (double)11.8, (double)0.23056, (double)13.067), LifestealerSkullBlock.box((double)4.2, (double)-2.96944, (double)9.467, (double)11.8, (double)-1.36944, (double)13.067)});
                    }
                    case WALL: {
                        yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)1.3, (double)2.933, (double)0.23056, (double)14.7, (double)16.333, (double)12.63056), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)1.5, (double)3.233, (double)0.33056, (double)14.5, (double)16.233, (double)12.33056), LifestealerSkullBlock.box((double)4.2, (double)2.933, (double)-1.36944, (double)11.8, (double)6.533, (double)0.23056), LifestealerSkullBlock.box((double)4.2, (double)2.933, (double)-2.96944, (double)11.8, (double)6.533, (double)-1.36944)});
                    }
                    case CEILING: 
                }
                yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)1.3, (double)3.36944, (double)-0.333, (double)14.7, (double)15.76944, (double)13.067), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)1.5, (double)3.66944, (double)-0.233, (double)14.5, (double)15.66944, (double)12.767), LifestealerSkullBlock.box((double)4.2, (double)15.76944, (double)9.467, (double)11.8, (double)17.36944, (double)13.067), LifestealerSkullBlock.box((double)4.2, (double)17.36944, (double)9.467, (double)11.8, (double)18.96944, (double)13.067)});
            }
            case Direction.NORTH -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)1.3, (double)0.23056, (double)2.933, (double)14.7, (double)12.63056, (double)16.333), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)1.5, (double)0.33056, (double)3.233, (double)14.5, (double)12.33056, (double)16.233), LifestealerSkullBlock.box((double)4.2, (double)-1.36944, (double)2.933, (double)11.8, (double)0.23056, (double)6.533), LifestealerSkullBlock.box((double)4.2, (double)-2.96944, (double)2.933, (double)11.8, (double)-1.36944, (double)6.533)});
                    }
                    case WALL: {
                        yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)1.3, (double)2.933, (double)3.36944, (double)14.7, (double)16.333, (double)15.76944), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)1.5, (double)3.233, (double)3.66944, (double)14.5, (double)16.233, (double)15.66944), LifestealerSkullBlock.box((double)4.2, (double)2.933, (double)15.76944, (double)11.8, (double)6.533, (double)17.36944), LifestealerSkullBlock.box((double)4.2, (double)2.933, (double)17.36944, (double)11.8, (double)6.533, (double)18.96944)});
                    }
                    case CEILING: 
                }
                yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)1.3, (double)3.36944, (double)2.933, (double)14.7, (double)15.76944, (double)16.333), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)1.5, (double)3.66944, (double)3.233, (double)14.5, (double)15.66944, (double)16.233), LifestealerSkullBlock.box((double)4.2, (double)15.76944, (double)2.933, (double)11.8, (double)17.36944, (double)6.533), LifestealerSkullBlock.box((double)4.2, (double)17.36944, (double)2.933, (double)11.8, (double)18.96944, (double)6.533)});
            }
            case Direction.EAST -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)-0.333, (double)0.23056, (double)1.3, (double)13.067, (double)12.63056, (double)14.7), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)-0.233, (double)0.33056, (double)1.5, (double)12.767, (double)12.33056, (double)14.5), LifestealerSkullBlock.box((double)9.467, (double)-1.36944, (double)4.2, (double)13.067, (double)0.23056, (double)11.8), LifestealerSkullBlock.box((double)9.467, (double)-2.96944, (double)4.2, (double)13.067, (double)-1.36944, (double)11.8)});
                    }
                    case WALL: {
                        yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)0.23056, (double)2.933, (double)1.3, (double)12.63056, (double)16.333, (double)14.7), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)0.33056, (double)3.233, (double)1.5, (double)12.33056, (double)16.233, (double)14.5), LifestealerSkullBlock.box((double)-1.36944, (double)2.933, (double)4.2, (double)0.23056, (double)6.533, (double)11.8), LifestealerSkullBlock.box((double)-2.96944, (double)2.933, (double)4.2, (double)-1.36944, (double)6.533, (double)11.8)});
                    }
                    case CEILING: 
                }
                yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)-0.333, (double)3.36944, (double)1.3, (double)13.067, (double)15.76944, (double)14.7), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)-0.233, (double)3.66944, (double)1.5, (double)12.767, (double)15.66944, (double)14.5), LifestealerSkullBlock.box((double)9.467, (double)15.76944, (double)4.2, (double)13.067, (double)17.36944, (double)11.8), LifestealerSkullBlock.box((double)9.467, (double)17.36944, (double)4.2, (double)13.067, (double)18.96944, (double)11.8)});
            }
            case Direction.WEST -> {
                switch ((AttachFace)state.getValue(FACE)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case FLOOR: {
                        yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)2.933, (double)0.23056, (double)1.3, (double)16.333, (double)12.63056, (double)14.7), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)3.233, (double)0.33056, (double)1.5, (double)16.233, (double)12.33056, (double)14.5), LifestealerSkullBlock.box((double)2.933, (double)-1.36944, (double)4.2, (double)6.533, (double)0.23056, (double)11.8), LifestealerSkullBlock.box((double)2.933, (double)-2.96944, (double)4.2, (double)6.533, (double)-1.36944, (double)11.8)});
                    }
                    case WALL: {
                        yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)3.36944, (double)2.933, (double)1.3, (double)15.76944, (double)16.333, (double)14.7), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)3.66944, (double)3.233, (double)1.5, (double)15.66944, (double)16.233, (double)14.5), LifestealerSkullBlock.box((double)15.76944, (double)2.933, (double)4.2, (double)17.36944, (double)6.533, (double)11.8), LifestealerSkullBlock.box((double)17.36944, (double)2.933, (double)4.2, (double)18.96944, (double)6.533, (double)11.8)});
                    }
                    case CEILING: 
                }
                yield Shapes.or((VoxelShape)LifestealerSkullBlock.box((double)2.933, (double)3.36944, (double)1.3, (double)16.333, (double)15.76944, (double)14.7), (VoxelShape[])new VoxelShape[]{LifestealerSkullBlock.box((double)3.233, (double)3.66944, (double)1.5, (double)16.233, (double)15.66944, (double)14.5), LifestealerSkullBlock.box((double)2.933, (double)15.76944, (double)4.2, (double)6.533, (double)17.36944, (double)11.8), LifestealerSkullBlock.box((double)2.933, (double)17.36944, (double)4.2, (double)6.533, (double)18.96944, (double)11.8)});
            }
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, FACE, WATERLOGGED});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean flag = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)super.getStateForPlacement(context).setValue(FACE, (Comparable)this.faceForDirection(context.getNearestLookingDirection()))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    private AttachFace faceForDirection(Direction direction) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR;
        }
        return AttachFace.WALL;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            world.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
        }
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }
}

