/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.chat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Unit;
import org.jetbrains.annotations.Nullable;

public class FormattedContentSink
implements FormattedText.StyledContentConsumer<Unit>,
FormattedCharSink {
    private final List<Map.Entry<StringBuilder, Style>> builders = new ArrayList<Map.Entry<StringBuilder, Style>>(Collections.singletonList(Map.entry(new StringBuilder(), Style.EMPTY)));
    @Nullable
    private Component component;
    @Nullable
    private String string;

    public FormattedContentSink(FormattedText formattedText) {
        formattedText.visit((FormattedText.StyledContentConsumer)this, Style.EMPTY);
        if (formattedText instanceof Component) {
            this.component = ((Component)formattedText).copy();
        }
    }

    public FormattedContentSink(FormattedCharSequence formattedCharSequence) {
        formattedCharSequence.accept((FormattedCharSink)this);
    }

    public Optional<Unit> accept(Style style, String string) {
        Map.Entry<StringBuilder, Style> entry = this.builders.get(this.builders.size() - 1);
        if (entry.getValue() == style || entry.getValue().isEmpty() && style.isEmpty()) {
            entry.getKey().append(string);
        } else {
            this.builders.add(Map.entry(new StringBuilder(string), style));
        }
        return Optional.empty();
    }

    public boolean accept(int width, Style style, int codePoint) {
        this.accept(style, String.valueOf(Character.toChars(codePoint)));
        return true;
    }

    public Component getComponent() {
        if (this.component == null) {
            MutableComponent component = null;
            for (Map.Entry<StringBuilder, Style> entry : this.builders) {
                MutableComponent componentFromEntry = Component.literal((String)entry.getKey().toString()).setStyle(entry.getValue());
                if (component == null) {
                    component = componentFromEntry;
                    continue;
                }
                component.append((Component)componentFromEntry);
            }
            Objects.requireNonNull(component, "component is null");
            this.component = component;
        }
        return this.component;
    }

    public String getString() {
        if (this.string == null) {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<StringBuilder, Style> entry : this.builders) {
                builder.append(this.getStringFormatFromStyle(entry.getValue()));
                builder.append((CharSequence)entry.getKey());
                builder.append(ChatFormatting.RESET);
            }
            this.string = builder.toString();
        }
        return this.string;
    }

    public String getStringFormatFromStyle(Style style) {
        if (style.isEmpty()) {
            return "";
        }
        return this.getFormatFromStyle(style).stream().map(ChatFormatting::toString).collect(Collectors.joining());
    }

    public List<ChatFormatting> getFormatFromStyle(Style style) {
        ChatFormatting color;
        ArrayList<ChatFormatting> list = new ArrayList<ChatFormatting>();
        if (style.getColor() != null && (color = ChatFormatting.getByName((String)style.getColor().serialize())) != null) {
            list.add(color);
        }
        if (style.isObfuscated()) {
            list.add(ChatFormatting.OBFUSCATED);
        }
        if (style.isBold()) {
            list.add(ChatFormatting.BOLD);
        }
        if (style.isStrikethrough()) {
            list.add(ChatFormatting.STRIKETHROUGH);
        }
        if (style.isUnderlined()) {
            list.add(ChatFormatting.UNDERLINE);
        }
        if (style.isItalic()) {
            list.add(ChatFormatting.ITALIC);
        }
        return list;
    }
}

