/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.event.v1.core;

import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.impl.PuzzlesLibMod;
import fuzs.puzzleslib.impl.event.core.EventPhaseImpl;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.NonExtendable
public interface EventPhase {
    public static final EventPhase DEFAULT = new EventPhaseImpl(ResourceLocationHelper.fromNamespaceAndPath("fabric", "default"), null, null);
    public static final EventPhase BEFORE = new EventPhaseImpl(PuzzlesLibMod.id("before"), DEFAULT, EventPhaseImpl.Ordering.BEFORE);
    public static final EventPhase AFTER = new EventPhaseImpl(PuzzlesLibMod.id("after"), DEFAULT, EventPhaseImpl.Ordering.AFTER);
    public static final EventPhase FIRST = new EventPhaseImpl(PuzzlesLibMod.id("first"), BEFORE, EventPhaseImpl.Ordering.BEFORE);
    public static final EventPhase LAST = new EventPhaseImpl(PuzzlesLibMod.id("last"), AFTER, EventPhaseImpl.Ordering.AFTER);

    public ResourceLocation identifier();

    public EventPhase parent();

    public void applyOrdering(BiConsumer<ResourceLocation, ResourceLocation> var1);

    public static EventPhase early(EventPhase eventPhase) {
        return new EventPhaseImpl(PuzzlesLibMod.id("early_" + eventPhase.identifier().getPath()), eventPhase, EventPhaseImpl.Ordering.BEFORE);
    }

    public static EventPhase late(EventPhase eventPhase) {
        return new EventPhaseImpl(PuzzlesLibMod.id("late_" + eventPhase.identifier().getPath()), eventPhase, EventPhaseImpl.Ordering.AFTER);
    }
}

