/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.common.util;

public class MathUtil {
    public static float lerp(double value, double min, double max) {
        return (float)(min + value * (max - min));
    }

    public static int randomInt(int min, int max) {
        return Math.round(MathUtil.lerp(Math.random(), min, max));
    }

    public static float randomFloat(float min, float max) {
        return MathUtil.lerp(Math.random(), min, max);
    }

    public static enum EaseType {
        EASEINSINE{

            @Override
            public double getEase(double x) {
                return 1.0 - Math.cos(x * Math.PI / 2.0);
            }
        }
        ,
        EASEOUTSINE{

            @Override
            public double getEase(double x) {
                return Math.sin(x * Math.PI / 2.0);
            }
        }
        ,
        EASEINOUTSINE{

            @Override
            public double getEase(double x) {
                return -(Math.cos(Math.PI * x) - 1.0) / 2.0;
            }
        }
        ,
        EASEINQUAD{

            @Override
            public double getEase(double x) {
                return x * x;
            }
        }
        ,
        EASEOUTQUAD{

            @Override
            public double getEase(double x) {
                return 1.0 - (1.0 - x) * (1.0 - x);
            }
        }
        ,
        EASEINOUTQUAD{

            @Override
            public double getEase(double x) {
                return x < 0.5 ? 2.0 * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 2.0) / 2.0;
            }
        }
        ,
        EASEINCUBIC{

            @Override
            public double getEase(double x) {
                return x * x * x;
            }
        }
        ,
        EASEOUTCUBIC{

            @Override
            public double getEase(double x) {
                return 1.0 - Math.pow(1.0 - x, 3.0);
            }
        }
        ,
        EASEINOUTCUBIC{

            @Override
            public double getEase(double x) {
                return x < 0.5 ? 4.0 * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 3.0) / 2.0;
            }
        }
        ,
        EASEINQUART{

            @Override
            public double getEase(double x) {
                return x * x * x * x;
            }
        }
        ,
        EASEOUTQUART{

            @Override
            public double getEase(double x) {
                return 1.0 - Math.pow(1.0 - x, 4.0);
            }
        }
        ,
        EASEINOUTQUART{

            @Override
            public double getEase(double x) {
                return x < 0.5 ? 8.0 * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 4.0) / 2.0;
            }
        }
        ,
        EASEINQUINT{

            @Override
            public double getEase(double x) {
                return x * x * x * x * x;
            }
        }
        ,
        EASEOUTQUINT{

            @Override
            public double getEase(double x) {
                return 1.0 - Math.pow(1.0 - x, 5.0);
            }
        }
        ,
        EASEINOUTQUINT{

            @Override
            public double getEase(double x) {
                return x < 0.5 ? 16.0 * x * x * x * x * x : 1.0 - Math.pow(-2.0 * x + 2.0, 5.0) / 2.0;
            }
        }
        ,
        EASEINEXPO{

            @Override
            public double getEase(double x) {
                return x == 0.0 ? 0.0 : Math.pow(2.0, 10.0 * x - 10.0);
            }
        }
        ,
        EASEOUTEXPO{

            @Override
            public double getEase(double x) {
                return x == 1.0 ? 1.0 : 1.0 - Math.pow(2.0, -10.0 * x);
            }
        }
        ,
        EASEINOUTEXPO{

            @Override
            public double getEase(double x) {
                return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? Math.pow(2.0, 20.0 * x - 10.0) / 2.0 : (2.0 - Math.pow(2.0, -20.0 * x + 10.0)) / 2.0));
            }
        }
        ,
        EASEINCIRC{

            @Override
            public double getEase(double x) {
                return 1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0));
            }
        }
        ,
        EASEOUTCIRC{

            @Override
            public double getEase(double x) {
                return Math.sqrt(1.0 - Math.pow(x - 1.0, 2.0));
            }
        }
        ,
        EASEINOUTCIRC{

            @Override
            public double getEase(double x) {
                return x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0 * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0 * x + 2.0, 2.0)) + 1.0) / 2.0;
            }
        }
        ,
        EASEINBACK{

            @Override
            public double getEase(double x) {
                double c1 = 1.70158;
                double c3 = c1 + 1.0;
                return c3 * x * x * x - c1 * x * x;
            }
        }
        ,
        EASEOUTBACK{

            @Override
            public double getEase(double x) {
                double c1 = 1.70158;
                double c3 = c1 + 1.0;
                return 1.0 + c3 * Math.pow(x - 1.0, 3.0) + c1 * Math.pow(x - 1.0, 2.0);
            }
        }
        ,
        EASEINOUTBACK{

            @Override
            public double getEase(double x) {
                double c1 = 1.70158;
                double c2 = c1 * 1.525;
                return x < 0.5 ? Math.pow(2.0 * x, 2.0) * ((c2 + 1.0) * 2.0 * x - c2) / 2.0 : (Math.pow(2.0 * x - 2.0, 2.0) * ((c2 + 1.0) * (x * 2.0 - 2.0) + c2) + 2.0) / 2.0;
            }
        }
        ,
        EASEINELASTIC{

            @Override
            public double getEase(double x) {
                double c4 = 2.0943951023931953;
                return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : -Math.pow(2.0, 10.0 * x - 10.0) * Math.sin((x * 10.0 - 10.75) * c4));
            }
        }
        ,
        EASEOUTELASTIC{

            @Override
            public double getEase(double x) {
                double c4 = 2.0943951023931953;
                return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : Math.pow(2.0, -10.0 * x) * Math.sin((x * 10.0 - 0.75) * c4) + 1.0);
            }
        }
        ,
        EASEINOUTELASTIC{

            @Override
            public double getEase(double x) {
                double c5 = 1.3962634015954636;
                double sin = Math.sin((20.0 * x - 11.125) * c5);
                return x == 0.0 ? 0.0 : (x == 1.0 ? 1.0 : (x < 0.5 ? -(Math.pow(2.0, 20.0 * x - 10.0) * sin) / 2.0 : Math.pow(2.0, -20.0 * x + 10.0) * sin / 2.0 + 1.0));
            }
        }
        ,
        EASEINBOUNCE{

            @Override
            public double getEase(double x) {
                return 1.0 - EASEOUTBOUNCE.getEase(1.0 - x);
            }
        }
        ,
        EASEOUTBOUNCE{

            @Override
            public double getEase(double x) {
                double n1 = 7.5625;
                double d1 = 2.75;
                if (x < 1.0 / d1) {
                    return n1 * x * x;
                }
                if (x < 2.0 / d1) {
                    return n1 * (x -= 1.5 / d1) * x + 0.75;
                }
                if (x < 2.5 / d1) {
                    return n1 * (x -= 2.25 / d1) * x + 0.9375;
                }
                return n1 * (x -= 2.625 / d1) * x + 0.984375;
            }
        }
        ,
        EASEINOUTBOUNCE{

            @Override
            public double getEase(double x) {
                return x < 0.5 ? (1.0 - EASEOUTBOUNCE.getEase(1.0 - 2.0 * x)) / 2.0 : (1.0 + EASEOUTBOUNCE.getEase(2.0 * x - 1.0)) / 2.0;
            }
        };


        public abstract double getEase(double var1);
    }
}

