/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.common.timer;

import invoker54.invocore.common.timer.MiniTicker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModTimer {
    protected static final Map<String, ModTimer> timerMap = new HashMap<String, ModTimer>();
    protected final List<String> allTimes = new ArrayList<String>();

    public static ModTimer getTimer(String modID, String name) {
        String fullName = modID + name + "watch";
        if (!timerMap.containsKey(fullName)) {
            timerMap.put(fullName, new ModTimer());
        }
        return timerMap.get(fullName);
    }

    public String record(MiniTicker<?> ticker, String whatItsFor) {
        String timeElapsed = "" + (double)ticker.getElapsedTime().longValue() / 1.0E9;
        String timeString = "It took " + timeElapsed + " seconds: " + whatItsFor;
        this.allTimes.add(timeString);
        ticker.reset();
        return timeString;
    }

    public MiniTicker<?> ticker() {
        return new MiniTicker<ModTimer>(this);
    }

    public List<String> grabTimes(boolean clear) {
        ArrayList<String> times = new ArrayList<String>(this.allTimes);
        if (clear) {
            this.allTimes.clear();
        }
        return times;
    }
}

