/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.common;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModLogger {
    private final Logger myLogger;
    private final AtomicBoolean debugMode;
    private double counter = 0.0;
    private static final List<ModLogger> loggers = new ArrayList<ModLogger>();

    private ModLogger(Logger myLogger, AtomicBoolean debugMode) {
        this.myLogger = myLogger;
        this.debugMode = debugMode;
    }

    public static ModLogger getLogger(Class<?> modClass, AtomicBoolean debugMode) {
        ModLogger newLogger = new ModLogger(LogManager.getLogger(modClass), debugMode);
        loggers.add(newLogger);
        return newLogger;
    }

    public void debug(String s) {
        double time = System.nanoTime();
        if (!this.debugMode.get()) {
            return;
        }
        this.myLogger.debug(s);
        this.counter += (double)System.nanoTime() - time;
    }

    public void info(String s) {
        double time = System.nanoTime();
        if (!this.debugMode.get()) {
            return;
        }
        this.myLogger.info(s);
        this.counter += (double)System.nanoTime() - time;
    }

    public void warn(String s) {
        double time = System.nanoTime();
        if (!this.debugMode.get()) {
            return;
        }
        this.myLogger.warn(s);
        this.counter += (double)System.nanoTime() - time;
    }

    public void error(String s) {
        double time = System.nanoTime();
        if (!this.debugMode.get()) {
            return;
        }
        this.myLogger.error(s);
        this.counter += (double)System.nanoTime() - time;
    }

    public void timePassed(boolean resetTime) {
        if (!this.debugMode.get()) {
            return;
        }
        this.myLogger.info(this.myLogger.getName() + "Time passed: " + this.counter / 1.0E9);
        if (resetTime) {
            this.counter = 0.0;
        }
    }

    public static void getAllTimePassed() {
        double totalTime = 0.0;
        for (ModLogger logger : loggers) {
            totalTime += logger.counter;
            logger.timePassed(true);
        }
        loggers.get(0).error("Total time passed: " + totalTime / 1.0E9);
    }
}

