/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client.util;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import invoker54.invocore.client.Ticker;
import invoker54.invocore.client.util.InvoZone;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class ClientUtil {
    private static Minecraft mC;
    public static final DecimalFormat d1;
    private static final Logger LOGGER;
    protected static final ArrayList<Bounds> cropBounds;

    public static Font getFont() {
        return ClientUtil.getMinecraft().font;
    }

    public static Minecraft getMinecraft() {
        if (mC == null) {
            mC = Minecraft.getInstance();
        }
        return mC;
    }

    public static Player getPlayer() {
        return ClientUtil.getMinecraft().player;
    }

    public static Level getWorld() {
        return ClientUtil.getMinecraft().level;
    }

    public static void drawWorldLine(PoseStack stack, Vec3 origin, Vec3 target, float lineWidth, int color) {
        stack.pushPose();
        Vec3 cam = ClientUtil.getMinecraft().gameRenderer.getMainCamera().getPosition().reverse();
        stack.translate(cam.x(), cam.y(), cam.z());
        cam = cam.reverse();
        Matrix4f lastPos = stack.last().pose();
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        Vec3 directionVector = target.vectorTo(cam).cross(origin.vectorTo(cam)).normalize();
        Vec3 originUP = origin.add(directionVector.scale((double)(lineWidth / 2.0f)));
        Vec3 originDOWN = origin.add(directionVector.scale((double)(-lineWidth / 2.0f)));
        Vec3 targetUP = target.add(directionVector.scale((double)(lineWidth / 2.0f)));
        Vec3 targetDOWN = target.add(directionVector.scale((double)(-lineWidth / 2.0f)));
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.addVertex(lastPos, (float)originUP.x(), (float)originUP.y(), (float)originUP.z()).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(lastPos, (float)targetUP.x(), (float)targetUP.y(), (float)targetUP.z()).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(lastPos, (float)targetDOWN.x(), (float)targetDOWN.y(), (float)targetDOWN.z()).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(lastPos, (float)originDOWN.x(), (float)originDOWN.y(), (float)originDOWN.z()).setColor(f, f1, f2, f3);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        stack.popPose();
    }

    public static void drawWorldLine(PoseStack stack, Vec3 origin, Vec3 target, float lineWidth, float u0, float imageWidth, float v0, float imageHeight, float imageScale) {
        stack.pushPose();
        Vec3 cam = ClientUtil.getMinecraft().gameRenderer.getMainCamera().getPosition().reverse();
        stack.translate(cam.x(), cam.y(), cam.z());
        cam = cam.reverse();
        Matrix4f lastPos = stack.last().pose();
        float u1 = (u0 /= imageScale) + imageWidth / imageScale;
        float v1 = (v0 /= imageScale) + imageHeight / imageScale;
        Vec3 directionVector = target.vectorTo(cam).cross(origin.vectorTo(cam)).normalize();
        Vec3 originUP = origin.add(directionVector.scale((double)(lineWidth / 2.0f)));
        Vec3 originDOWN = origin.add(directionVector.scale((double)(-lineWidth / 2.0f)));
        Vec3 targetUP = target.add(directionVector.scale((double)(lineWidth / 2.0f)));
        Vec3 targetDOWN = target.add(directionVector.scale((double)(-lineWidth / 2.0f)));
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferbuilder.addVertex(lastPos, (float)originUP.x(), (float)originUP.y(), (float)originUP.z()).setUv(u0, v0);
        bufferbuilder.addVertex(lastPos, (float)targetUP.x(), (float)targetUP.y(), (float)targetUP.z()).setUv(u1, v0);
        bufferbuilder.addVertex(lastPos, (float)targetDOWN.x(), (float)targetDOWN.y(), (float)targetDOWN.z()).setUv(u1, v1);
        bufferbuilder.addVertex(lastPos, (float)originDOWN.x(), (float)originDOWN.y(), (float)originDOWN.z()).setUv(u0, v1);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
        stack.popPose();
    }

    public static void blitImage(PoseStack stack, InvoZone renderZone, InvoZone imageZone, float fullImageWidth, float fullImageHeight) {
        ClientUtil.blitImage(stack, renderZone.x(), renderZone.width(), renderZone.y(), renderZone.height(), imageZone.x(), imageZone.width(), imageZone.y(), imageZone.height(), fullImageWidth, fullImageHeight);
    }

    public static void blitImage(PoseStack stack, float x0, float width, float y0, float height, float u0, float imageWidth, float v0, float imageHeight, float fullImageWidth, float fullImageHeight) {
        Matrix4f lastPos = stack.last().pose();
        float x1 = x0 + width;
        float y1 = y0 + height;
        float u1 = (u0 /= fullImageWidth) + imageWidth / fullImageWidth;
        float v1 = (v0 /= fullImageHeight) + imageHeight / fullImageHeight;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        bufferbuilder.addVertex(lastPos, x0, y1, 0.0f).setUv(u0, v1);
        bufferbuilder.addVertex(lastPos, x1, y1, 0.0f).setUv(u1, v1);
        bufferbuilder.addVertex(lastPos, x1, y0, 0.0f).setUv(u1, v0);
        bufferbuilder.addVertex(lastPos, x0, y0, 0.0f).setUv(u0, v0);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
        RenderSystem.enableDepthTest();
    }

    public static void blitColor(PoseStack stack, InvoZone renderZone, int color) {
        ClientUtil.blitColor(stack, renderZone.x(), renderZone.width(), renderZone.y(), renderZone.height(), color);
    }

    public static void blitColor(PoseStack stack, float x0, float width, float y0, float height, int color) {
        Matrix4f lastPos = stack.last().pose();
        float x1 = x0 + width;
        float y1 = y0 + height;
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BufferBuilder bufferbuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        bufferbuilder.addVertex(lastPos, x0, y1, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(lastPos, x1, y1, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(lastPos, x1, y0, 0.0f).setColor(f, f1, f2, f3);
        bufferbuilder.addVertex(lastPos, x0, y0, 0.0f).setColor(f, f1, f2, f3);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.build());
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
    }

    public static void blitItem(PoseStack stack, InvoZone renderZone, ItemStack itemStack) {
        ClientUtil.blitItem(stack, renderZone.x(), renderZone.width(), renderZone.y(), renderZone.height(), itemStack);
    }

    public static void blitItem(PoseStack stack, float x0, float width, float y0, float height, ItemStack itemStack) {
        boolean flag;
        ClientUtil.getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS).setFilter(false, false);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        ItemRenderer renderer = mC.getItemRenderer();
        BakedModel bakedModel = renderer.getModel(itemStack, null, null, 0);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.translate(x0, y0, 100.0f);
        posestack.translate(width / 2.0f, height / 2.0f, 0.0f);
        boolean bl = flag = !bakedModel.usesBlockLight();
        if (flag) {
            Lighting.setupForFlatItems();
            posestack.scale(1.0f, -1.0f, 1.0f);
        } else {
            Lighting.setupFor3DItems();
        }
        posestack.scale(width, height, 1.0f);
        RenderSystem.applyModelViewMatrix();
        renderer.render(itemStack, ItemDisplayContext.GUI, false, stack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, bakedModel);
        bufferSource.endBatch();
        if (flag) {
            Lighting.setupFor3DItems();
        }
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableDepthTest();
    }

    public static Vec3 smoothLerp(Vec3 oldPos, Vec3 newPos, boolean useDelta) {
        return new Vec3(ClientUtil.smoothLerp(oldPos.x, newPos.x, useDelta), ClientUtil.smoothLerp(oldPos.y, newPos.y, useDelta), ClientUtil.smoothLerp(oldPos.z, newPos.z, useDelta));
    }

    public static double smoothLerp(double oldDouble, double newDouble, boolean useDelta) {
        return Mth.lerp((double)(useDelta ? (double)Ticker.getDelta(true, true) : (double)ClientUtil.getMinecraft().getFrameTimeNs()), (double)oldDouble, (double)newDouble);
    }

    public static void copyEntityMovement(LivingEntity copier, LivingEntity toCopy) {
        copier.moveTo(toCopy.position());
        copier.xo = toCopy.xo;
        copier.xOld = toCopy.xOld;
        copier.yo = toCopy.yo;
        copier.yOld = toCopy.yOld;
        copier.zo = toCopy.zo;
        copier.zOld = toCopy.zOld;
        copier.setDeltaMovement(toCopy.getDeltaMovement());
        copier.setYHeadRot(toCopy.getYHeadRot());
        copier.yHeadRotO = toCopy.yHeadRotO;
        copier.setYBodyRot(toCopy.yBodyRot);
        copier.yBodyRotO = toCopy.yBodyRotO;
    }

    public static boolean inBounds(float xSpot, float ySpot, Bounds bounds) {
        if (xSpot < (float)bounds.x0 || xSpot > (float)bounds.x1) {
            return false;
        }
        return !(ySpot < (float)bounds.y0) && !(ySpot > (float)bounds.y1);
    }

    public static void beginCrop(double x, double width, double y, double height, boolean fresh) {
        if (fresh) {
            cropBounds.add(new Bounds((int)x, (int)width, (int)y, (int)height));
        }
        double scale = ClientUtil.getMinecraft().getWindow().getGuiScale();
        int windowHeight = ClientUtil.getMinecraft().getWindow().getGuiScaledHeight();
        y = (double)windowHeight - (height + y);
        RenderSystem.enableScissor((int)((int)(x *= scale)), (int)((int)(y *= scale)), (int)((int)(width *= scale)), (int)((int)(height *= scale)));
    }

    public static void endCrop() {
        if (cropBounds.size() != 0) {
            cropBounds.remove(cropBounds.size() - 1);
        }
        if (!cropBounds.isEmpty()) {
            Bounds cropBound = cropBounds.get(cropBounds.size() - 1);
            ClientUtil.beginCrop(cropBound.x0, cropBound.x1 - cropBound.x0, cropBound.y0, cropBound.y1 - cropBound.y0, false);
        } else {
            RenderSystem.disableScissor();
        }
    }

    public static String ticksToTime(int ticks) {
        int hours = ticks / 72000;
        int minutes = (ticks -= hours * 7200) / 1200;
        int seconds = (ticks -= minutes * 1200) / 20;
        return (hours <= 9 ? "0" : "") + hours + ":" + (minutes <= 9 ? "0" : "") + minutes + ":" + (seconds <= 9 ? "0" : "") + seconds;
    }

    public static String formatValue(double value) {
        if (value == 0.0) {
            return "0";
        }
        String suffix = " KMBT";
        Object formattedNumber = "";
        DecimalFormat formatter = new DecimalFormat("#,###.#");
        int power = (int)StrictMath.log10(value);
        formattedNumber = formatter.format(value /= Math.pow(10.0, power / 3 * 3));
        return ((String)(formattedNumber = (String)formattedNumber + suffix.charAt(power / 3))).length() > 4 ? ((String)formattedNumber).replaceAll("\\.[0-9]+ ", "") : formattedNumber;
    }

    public static TextureManager getTextureManager() {
        return mC.getTextureManager();
    }

    static {
        d1 = new DecimalFormat("0.0");
        LOGGER = LogManager.getLogger();
        cropBounds = new ArrayList();
    }

    public static class Bounds {
        int x0;
        int x1;
        int y0;
        int y1;

        public Bounds(int x, int width, int y, int height) {
            this.x0 = x;
            this.x1 = x + width;
            this.y0 = y;
            this.y1 = y + height;
        }

        public Bounds() {
        }

        public void adjustBounds(int x, int width, int y, int height) {
            this.x0 = x;
            this.x1 = x + width;
            this.y0 = y;
            this.y1 = y + height;
        }

        public int getMinX() {
            return this.x0;
        }

        public int getMaxX() {
            return this.x1;
        }

        public int getMinY() {
            return this.y0;
        }

        public int getMaxY() {
            return this.y1;
        }
    }

    public static class Image {
        protected ResourceLocation location;
        protected final InvoZone imageZone;
        protected final InvoZone renderZone;
        protected ImageType type = ImageType.Stretch;
        protected final float fullImageWidth;
        protected final float fullImageHeight;

        public Image(ResourceLocation loc, float u0, float imageWidth, float v0, float imageHeight) {
            this(loc, u0, imageWidth, v0, imageHeight, imageWidth, imageHeight);
        }

        public Image(ResourceLocation loc, float u0, float imageWidth, float v0, float imageHeight, float fullImageWidth, float fullImageHeight) {
            this.location = loc;
            this.imageZone = new InvoZone(u0, imageWidth, v0, imageHeight);
            this.renderZone = new InvoZone(0.0f, imageWidth, 0.0f, imageHeight);
            this.fullImageWidth = fullImageWidth;
            this.fullImageHeight = fullImageHeight;
        }

        public void resetScale() {
            this.renderZone.setWidth(this.imageZone.width());
            this.renderZone.setHeight(this.imageZone.height());
        }

        public InvoZone getRenderZone() {
            return this.renderZone;
        }

        public InvoZone getImageZone() {
            return this.imageZone;
        }

        public boolean isMouseOver(int mouseX, int mouseY) {
            return (float)mouseX >= this.renderZone.x() && (float)mouseX <= this.renderZone.x() + this.renderZone.width() && (float)mouseY >= this.renderZone.y() && (float)mouseY <= this.renderZone.y() + this.renderZone.height();
        }

        public void setType(ImageType imageType) {
            this.type = imageType;
        }

        public void render(PoseStack stack) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.location);
            ClientUtil.blitImage(stack, this.renderZone, this.imageZone, this.fullImageWidth, this.fullImageHeight);
        }

        public static enum ImageType {
            Stretch,
            Tile,
            NineSlice;

        }
    }

    public static class SimpleButton
    extends Button {
        public boolean hidden = false;

        public SimpleButton(int x, int y, int width, int height, MutableComponent textComponent, Button.OnPress onPress) {
            super(x, y, width, height, (Component)textComponent, onPress, a -> textComponent);
            this.visible = true;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.renderWidget(guiGraphics, mouseX, mouseY, partialTick);
        }
    }
}

