/*
 * Decompiled with CFR 0.152.
 */
package invoker54.invocore.client;

import invoker54.invocore.client.util.ClientUtil;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(value={Dist.CLIENT}, modid="invocore")
public class Ticker {
    private static long ticksInGame = 0L;
    private static float partialTicks = 0.0f;
    private static float delta = 0.0f;
    private static float total = 0.0f;
    private static final Logger LOGGER = LogManager.getLogger();

    private static void calcDelta() {
        float oldTotal = total;
        total = (float)ticksInGame + partialTicks;
        delta = total - oldTotal;
    }

    @SubscribeEvent
    protected static void renderTick(EntityTickEvent.Pre event) {
        partialTicks = ClientUtil.getMinecraft().getTimer().getGameTimeDeltaPartialTick(true);
    }

    @SubscribeEvent
    protected static void clientTickEnd(ClientTickEvent.Post event) {
        ++ticksInGame;
        partialTicks = 0.0f;
        Ticker.calcDelta();
    }

    public static float getDelta(boolean canPause, boolean inTicks) {
        return (canPause ? (ClientUtil.getMinecraft().isPaused() ? 0.0f : delta) : delta) / (float)(inTicks ? 1 : 20);
    }
}

