/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.common.util.ItemStackUtil;

public sealed interface BookIcon {
    public void render(GuiGraphics var1, int var2, int var3);

    public static BookIcon from(String str) {
        if (str.endsWith(".png")) {
            return new TextureIcon(ResourceLocation.tryParse((String)str));
        }
        try {
            ItemStack stack = ItemStackUtil.loadStackFromString(str, (HolderLookup.Provider)RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
            return new StackIcon(stack);
        }
        catch (Exception e) {
            PatchouliAPI.LOGGER.warn("Invalid icon item stack: {}", (Object)e.getMessage());
            return new StackIcon(ItemStack.EMPTY);
        }
    }

    public record TextureIcon(ResourceLocation texture) implements BookIcon
    {
        @Override
        public void render(GuiGraphics graphics, int x, int y) {
            graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
            graphics.blit(this.texture(), x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public record StackIcon(ItemStack stack) implements BookIcon
    {
        @Override
        public void render(GuiGraphics graphics, int x, int y) {
            graphics.renderItem(this.stack(), x, y);
            graphics.renderItemDecorations(Minecraft.getInstance().font, this.stack(), x, y);
        }
    }
}

