/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.book.Book;
import vazkii.patchouli.common.book.BookRegistry;

public class BookContentResourceListenerLoader
extends SimpleJsonResourceReloadListener
implements BookContentLoader {
    public static final BookContentResourceListenerLoader INSTANCE = new BookContentResourceListenerLoader();
    private static final Pattern ID_READER = Pattern.compile("(?<bookId>[a-z0-9_.-]+)/(?<lang>[a-z0-9_.-]+)/(?<folder>[a-z0-9_.-]+)/(?<entryId>[a-z0-9/._-]+)");
    private Map<ResourceLocation, Map<ResourceLocation, JsonElement>> data;

    private BookContentResourceListenerLoader() {
        super(BookRegistry.GSON, "patchouli_books");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, Map<ResourceLocation, JsonElement>> data = new HashMap<ResourceLocation, Map<ResourceLocation, JsonElement>>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            ResourceLocation key = entry.getKey();
            Matcher matcher = ID_READER.matcher(key.getPath());
            if (!matcher.matches()) {
                PatchouliAPI.LOGGER.trace("Ignored file {}", (Object)key);
                continue;
            }
            ResourceLocation bookId = ResourceLocation.fromNamespaceAndPath((String)key.getNamespace(), (String)matcher.group("bookId"));
            data.computeIfAbsent(bookId, id -> new HashMap()).put(entry.getKey(), entry.getValue());
        }
        int count = data.values().stream().mapToInt(Map::size).sum();
        PatchouliAPI.LOGGER.info("{} preloaded {} jsons", (Object)this.getClass().getSimpleName(), (Object)count);
        this.data = data;
    }

    @Override
    public void findFiles(Book book, String dir, List<ResourceLocation> list) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map<ResourceLocation, JsonElement> map = this.data.get(book.id);
        if (map == null) {
            return;
        }
        for (ResourceLocation id : map.keySet()) {
            Matcher matcher = ID_READER.matcher(id.getPath());
            if (!matcher.matches() || !dir.equals(matcher.group("folder")) || !"en_us".equals(matcher.group("lang"))) continue;
            list.add(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)matcher.group("entryId")));
        }
        PatchouliAPI.LOGGER.info("{}: Files found in {}", (Object)this.getClass().getSimpleName(), (Object)stopwatch.stop());
    }

    @Override
    @Nullable
    public BookContentLoader.LoadResult loadJson(Book book, ResourceLocation file) {
        PatchouliAPI.LOGGER.trace("Loading {}", (Object)file);
        Map<ResourceLocation, JsonElement> map = this.data.get(book.id);
        if (map == null) {
            return null;
        }
        String path = file.getPath();
        String relativizedPath = path.substring(0, path.length() - 5).split("/", 2)[1];
        JsonElement json = map.get(ResourceLocation.fromNamespaceAndPath((String)file.getNamespace(), (String)relativizedPath));
        if (json != null) {
            return new BookContentLoader.LoadResult(json, null);
        }
        return null;
    }
}

