/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.registration;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.event.common.ResourceEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.craftedcore.registration.neoforge.SynchronizedReloadListenerRegistryImpl;

public class SynchronizedReloadListenerRegistry {
    private static final Map<ResourceLocation, SynchronizedJsonReloadListener> listener = new HashMap<ResourceLocation, SynchronizedJsonReloadListener>();

    public static void register(SynchronizedJsonReloadListener reloadListener, ResourceLocation id) {
        listener.put(id, reloadListener);
        if (PlatformData.getEnv() == Dist.CLIENT) {
            reloadListener.registerPacketReceiver();
        }
        ModernNetworking.registerType(reloadListener.RELOAD_SYNC);
        SynchronizedReloadListenerRegistry.onRegister(reloadListener, id);
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void onRegister(SynchronizedJsonReloadListener reloadListener, ResourceLocation id) {
        void var1_1;
        SynchronizedReloadListenerRegistryImpl.onRegister(reloadListener, (ResourceLocation)var1_1);
    }

    @Contract(value=" -> new")
    @ApiStatus.Internal
    @NotNull
    public static List<SynchronizedJsonReloadListener> getAllListener() {
        return new ArrayList<SynchronizedJsonReloadListener>(listener.values());
    }

    public static SynchronizedJsonReloadListener get(ResourceLocation id) {
        return listener.get(id);
    }

    public static void initialize() {
        ResourceEvents.DATA_PACK_SYNC.register(SynchronizedReloadListenerRegistry::sendAllToPlayer);
    }

    private static void sendAllToPlayer(ServerPlayer player) {
        for (SynchronizedJsonReloadListener reloadListener : listener.values()) {
            reloadListener.sendSyncPacket(player);
        }
    }
}

