/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.platform;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.awt.Color;
import java.io.IOException;
import java.lang.module.ModuleDescriptor;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.CraftedCoreConfig;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.craftedcore.util.NetUtils;

public class VersionChecker {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, ModuleDescriptor.Version> CACHED_VERSION = new HashMap<String, ModuleDescriptor.Version>();
    private static final List<String> INVALID_VERSIONS = List.of("1.16.5", "1.18.2", "1.19.4", "1.20.1", "1.20.2", "1.20.4", "1.20.5");

    private static void sendUpdateMessage(ServerPlayer player, Component modName, ModuleDescriptor.Version newestVersion) {
        CraftedCore.LOGGER.warn(TComponent.translatable("craftedcore.update", modName.getString(), newestVersion).getString());
        player.sendSystemMessage((Component)TComponent.literal(Component.translatable((String)"craftedcore.update", (Object[])new Object[]{modName, newestVersion}).getString()).withColor(new Color(255, 255, 0).getRGB()));
    }

    public static void registerMavenChecker(String modid, URL mavenURL, Component modName) {
        PlayerEvents.PLAYER_JOIN.register(player -> CompletableFuture.runAsync(() -> {
            if (CraftedCoreConfig.INSTANCE != null && CraftedCoreConfig.INSTANCE.enableVersionChecking) {
                ModuleDescriptor.Version localVersion;
                ModuleDescriptor.Version newestVersion = localVersion = PlatformData.getModVersion(modid);
                if (CACHED_VERSION.containsKey(modid)) {
                    newestVersion = CACHED_VERSION.get(modid);
                } else {
                    ArrayList<String> remoteVersions = new ArrayList<String>();
                    try {
                        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                        factory.setIgnoringComments(true);
                        factory.setIgnoringElementContentWhitespace(true);
                        factory.setValidating(false);
                        DocumentBuilder builder = factory.newDocumentBuilder();
                        Document xmlFile = builder.parse(new InputSource(mavenURL.openStream()));
                        NodeList nodeList = xmlFile.getElementsByTagName("version");
                        for (int i = 0; i < nodeList.getLength(); ++i) {
                            remoteVersions.add(nodeList.item(i).getTextContent());
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof UnresolvedAddressException || e instanceof SocketException || e instanceof UnknownHostException) {
                            CraftedCore.reportMissingInternet(e);
                        }
                        CraftedCore.LOGGER.error("Caught an error while getting the newest versions from: {}", (Object)mavenURL, (Object)e);
                    }
                    ArrayList<ModuleDescriptor.Version> versions = new ArrayList<ModuleDescriptor.Version>(VersionChecker.processVersionListWithDefaultLayout(remoteVersions, true, INVALID_VERSIONS));
                    if (!versions.isEmpty()) {
                        newestVersion = (ModuleDescriptor.Version)versions.get(versions.size() - 1);
                    }
                    CACHED_VERSION.put(modid, newestVersion);
                }
                if (localVersion != null && newestVersion != null && newestVersion.compareTo(localVersion) > 0) {
                    VersionChecker.sendUpdateMessage(player, modName, newestVersion);
                }
            }
        }));
    }

    public static void registerDefaultGitHubChecker(String modid, String owner, String repo, Component modName) {
        VersionChecker.registerGitHubChecker(modid, owner, repo, false, true, modName, INVALID_VERSIONS);
    }

    public static void registerGitHubChecker(String modid, String owner, String repo, boolean releasesInsteadOfTags, boolean useLastPartOfVersion, Component modName, List<String> invalidVersions) {
        PlayerEvents.PLAYER_JOIN.register(player -> CompletableFuture.runAsync(() -> {
            if (CraftedCoreConfig.INSTANCE != null && CraftedCoreConfig.INSTANCE.enableVersionChecking) {
                ModuleDescriptor.Version localVersion;
                ModuleDescriptor.Version newestVersion = localVersion = PlatformData.getModVersion(modid);
                if (!CACHED_VERSION.containsKey(modid)) {
                    List<String> remoteVersions = VersionChecker.getVersionsFromGitHub(owner, repo, releasesInsteadOfTags);
                    ArrayList<ModuleDescriptor.Version> versions = new ArrayList<ModuleDescriptor.Version>(VersionChecker.processVersionListWithDefaultLayout(remoteVersions, useLastPartOfVersion, invalidVersions));
                    if (!versions.isEmpty()) {
                        newestVersion = (ModuleDescriptor.Version)versions.get(versions.size() - 1);
                    }
                    CACHED_VERSION.put(modid, newestVersion);
                } else {
                    newestVersion = CACHED_VERSION.get(modid);
                }
                if (localVersion != null && newestVersion != null && newestVersion.compareTo(localVersion) > 0) {
                    VersionChecker.sendUpdateMessage(player, modName, newestVersion);
                }
            }
        }));
    }

    private static List<ModuleDescriptor.Version> processVersionListWithDefaultLayout(List<String> versions, boolean useLast, List<String> invalidVersions) {
        ArrayList<String> sortedVersions = new ArrayList<String>();
        for (String version : versions) {
            if (!(version = VersionChecker.stripModLoader(version)).contains("-")) continue;
            String[] splitVersion = version.split("-");
            String processedVersion = splitVersion[useLast && splitVersion.length > 1 ? 1 : 0];
            if (version.isBlank() || sortedVersions.contains(processedVersion) || invalidVersions.contains(processedVersion)) continue;
            sortedVersions.add(processedVersion);
        }
        return sortedVersions.stream().map(ModuleDescriptor.Version::parse).sorted().toList();
    }

    private static String stripModLoader(String input) {
        String s = input.toLowerCase();
        List<String> modLoader = List.of("fabric", "neoforge", "forge", "quilt");
        for (String loader : modLoader) {
            if (s.contains(loader + "-")) {
                s = s.replaceAll(loader + "-", "");
                continue;
            }
            if (!s.contains(loader)) continue;
            s = s.replaceAll(loader, "");
        }
        if (s.startsWith("v")) {
            s = s.replaceFirst("v", "");
        }
        if (s.replaceAll("-", "").isBlank()) {
            return "";
        }
        return s;
    }

    private static List<String> getVersionsFromGitHub(String owner, String repo, boolean releasesInsteadOfTags) {
        String url = "https://api.github.com/repos/" + owner + "/" + repo + (releasesInsteadOfTags ? "/releases" : "/tags");
        Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        ArrayList<String> versions = new ArrayList<String>();
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("Accept", "application/vnd.github.v3+json");
            JsonArray jsonArray = NetUtils.getJsonResponse(GSON, header, new URI(url).toURL()).getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                versions.add(jsonElement.getAsJsonObject().get("name").getAsString());
            }
        }
        catch (IOException | URISyntaxException e) {
            if (e instanceof UnresolvedAddressException || e instanceof SocketException || e instanceof UnknownHostException) {
                CraftedCore.reportMissingInternet(e);
            }
            CraftedCore.LOGGER.error("Caught an error while getting the newest versions from: {}", (Object)url, (Object)e);
        }
        return versions;
    }

    public static void registerModrinthChecker(String modid, String slug, Component modName) {
        VersionChecker.registerModrinthChecker(modid, slug, true, modName, INVALID_VERSIONS);
    }

    public static void registerModrinthChecker(String modid, String slug, boolean useLastPartOfVersion, Component modName, List<String> invalidVersions) {
        PlayerEvents.PLAYER_JOIN.register(player -> CompletableFuture.runAsync(() -> {
            if (CraftedCoreConfig.INSTANCE != null && CraftedCoreConfig.INSTANCE.enableVersionChecking) {
                ModuleDescriptor.Version localVersion;
                ModuleDescriptor.Version newestVersion = localVersion = PlatformData.getModVersion(modid);
                if (!CACHED_VERSION.containsKey(modid)) {
                    List<String> remoteVersions = VersionChecker.getVersionsFromModrinth(slug);
                    ArrayList<ModuleDescriptor.Version> versions = new ArrayList<ModuleDescriptor.Version>(VersionChecker.processVersionListWithDefaultLayout(remoteVersions, useLastPartOfVersion, invalidVersions));
                    if (!versions.isEmpty()) {
                        newestVersion = (ModuleDescriptor.Version)versions.get(versions.size() - 1);
                    }
                    CACHED_VERSION.put(modid, newestVersion);
                } else {
                    newestVersion = CACHED_VERSION.get(modid);
                }
                if (localVersion != null && newestVersion != null && newestVersion.compareTo(localVersion) > 0) {
                    VersionChecker.sendUpdateMessage(player, modName, newestVersion);
                }
            }
        }));
    }

    private static List<String> getVersionsFromModrinth(String slug) {
        String url = VersionChecker.getModrinthUrl(slug);
        Gson GSON = new GsonBuilder().setPrettyPrinting().create();
        ArrayList<String> versions = new ArrayList<String>();
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("User-Agent", "crafted-core");
            JsonArray jsonArray = NetUtils.getJsonResponse(GSON, header, new URI(url).toURL()).getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                versions.add(jsonElement.getAsJsonObject().get("name").getAsString());
            }
        }
        catch (Exception e) {
            if (e instanceof UnresolvedAddressException || e instanceof SocketException || e instanceof UnknownHostException) {
                CraftedCore.reportMissingInternet(e);
            }
            CraftedCore.LOGGER.error("Caught an error while getting the newest versions from: {}", (Object)url, (Object)e);
        }
        return versions;
    }

    @NotNull
    private static String getModrinthUrl(String slug) {
        String baseUrl = "https://api.modrinth.com/v2/project/" + slug + "/version";
        PlatformData.ModLoader modLoader = PlatformData.getModLoaderId();
        String loaders = modLoader != PlatformData.ModLoader.OTHER ? "?loaders=[\"" + modLoader.name().toLowerCase() + "\"]" : "";
        ModuleDescriptor.Version mcVersion = PlatformData.getModVersion("minecraft");
        String params = loaders + (String)(mcVersion != null ? "&game_versions=[\"" + mcVersion.toString() + "\"]" : "");
        return (baseUrl + params).replace("\"", "%22");
    }
}

