/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.network.neoforge.ModernNetworkingImpl;

public class ModernNetworking {
    private static final Map<ResourceLocation, CustomPacketPayload.Type<PacketPayload>> TYPES = new HashMap<ResourceLocation, CustomPacketPayload.Type<PacketPayload>>();

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerReceiver(Side side, ResourceLocation id, Receiver receiver) {
        void var2_2;
        void var1_1;
        ModernNetworkingImpl.registerReceiver(side, (ResourceLocation)var1_1, (Receiver)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerType(ResourceLocation id) {
        ModernNetworkingImpl.registerType(id);
    }

    public static CustomPacketPayload.Type<PacketPayload> getType(ResourceLocation id) {
        if (!TYPES.containsKey(id)) {
            TYPES.put(id, (CustomPacketPayload.Type<PacketPayload>)new CustomPacketPayload.Type(id));
        }
        return TYPES.get(id);
    }

    public static void sendToPlayer(ServerPlayer player, ResourceLocation packetId, CompoundTag data) {
        player.connection.send(ModernNetworking.toPacket(Side.S2C, new PacketPayload(packetId, data)));
    }

    public static void sendToPlayers(Iterable<ServerPlayer> players, ResourceLocation packetId, CompoundTag data) {
        for (ServerPlayer player : players) {
            ModernNetworking.sendToPlayer(player, packetId, data);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void sendToServer(ResourceLocation packetId, CompoundTag data) {
        ClientPacketListener connection = Minecraft.getInstance().getConnection();
        if (connection != null) {
            connection.send(ModernNetworking.toPacket(Side.C2S, new PacketPayload(packetId, data)));
        }
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ApiStatus.Internal
    @ExpectPlatform.Transformed
    public static Packet<?> toPacket(Side side, CustomPacketPayload payload) {
        void var1_1;
        return ModernNetworkingImpl.toPacket(side, (CustomPacketPayload)var1_1);
    }

    public static enum Side {
        S2C,
        C2S;

    }

    @ApiStatus.Internal
    public record PacketPayload(ResourceLocation id, CompoundTag nbt) implements CustomPacketPayload
    {
        public PacketPayload(RegistryFriendlyByteBuf buf) {
            this(buf.readResourceLocation(), buf.readNbt());
        }

        public void write(RegistryFriendlyByteBuf buf) {
            buf.writeResourceLocation(this.id);
            buf.writeNbt((Tag)this.nbt);
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ModernNetworking.getType(this.id);
        }

        public static StreamCodec<RegistryFriendlyByteBuf, PacketPayload> streamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, PacketPayload>(){

                @NotNull
                public PacketPayload decode(@NotNull RegistryFriendlyByteBuf buf) {
                    return new PacketPayload(buf);
                }

                public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull PacketPayload payload) {
                    buf.writeResourceLocation(payload.id);
                    buf.writeNbt((Tag)payload.nbt);
                }
            };
        }
    }

    public static enum Env {
        CLIENT,
        SERVER;

    }

    public static interface Context {
        public Player getPlayer();

        public Env getEnv();

        public void queue(Runnable var1);
    }

    @FunctionalInterface
    public static interface Receiver {
        public void receive(Context var1, CompoundTag var2);
    }
}

