/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.neoforge.client;

import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import tocraft.craftedcore.event.client.ClientPlayerEvents;
import tocraft.craftedcore.event.client.ClientTickEvents;
import tocraft.craftedcore.event.client.RenderEvents;

@OnlyIn(value=Dist.CLIENT)
public class CraftedCoreNeoForgeEventHandlerClient {
    @SubscribeEvent
    public void event(RenderGuiEvent.Post event) {
        RenderEvents.HUD_RENDERING.invoke().render(event.getGuiGraphics(), event.getPartialTick());
    }

    @SubscribeEvent
    public void event(ClientTickEvent.Pre event) {
        ClientTickEvents.CLIENT_PRE.invoke().tick(Minecraft.getInstance());
    }

    @SubscribeEvent
    public void event(ClientTickEvent.Post event) {
        ClientTickEvents.CLIENT_POST.invoke().tick(Minecraft.getInstance());
    }

    @SubscribeEvent
    public void event(RenderGuiLayerEvent.Pre event) {
        switch (event.getName().getPath()) {
            case "player_health": {
                InteractionResult result = RenderEvents.RENDER_HEALTH.invoke().render(event.getGuiGraphics(), (Player)Minecraft.getInstance().player);
                if (result != InteractionResult.FAIL) break;
                event.setCanceled(true);
                break;
            }
            case "food_level": {
                InteractionResult result = RenderEvents.RENDER_FOOD.invoke().render(event.getGuiGraphics(), (Player)Minecraft.getInstance().player);
                if (result != InteractionResult.FAIL) break;
                event.setCanceled(true);
                break;
            }
            case "air_level": {
                InteractionResult result = RenderEvents.RENDER_BREATH.invoke().render(event.getGuiGraphics(), (Player)Minecraft.getInstance().player);
                if (result != InteractionResult.FAIL) break;
                event.setCanceled(true);
                break;
            }
            case "vehicle_health": {
                InteractionResult result = RenderEvents.RENDER_MOUNT_HEALTH.invoke().render(event.getGuiGraphics(), (Player)Minecraft.getInstance().player);
                if (result != InteractionResult.FAIL) break;
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void event(ClientPlayerNetworkEvent.LoggingOut event) {
        ClientPlayerEvents.CLIENT_PLAYER_QUIT.invoke().quit(event.getPlayer());
    }
}

