/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.mixin.client;

import java.io.File;
import net.minecraft.CrashReport;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.util.TraceUtils;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin {
    @Inject(method={"crash(Lnet/minecraft/client/Minecraft;Ljava/io/File;Lnet/minecraft/CrashReport;)V"}, at={@At(value="HEAD")})
    private static void onCrash(Minecraft minecraft, File gameDirectory, CrashReport report, CallbackInfo ci) {
        StringBuilder crashReportBuilder = new StringBuilder();
        TraceUtils.printMixinTrace(report.getException().getStackTrace(), crashReportBuilder);
        System.out.println(crashReportBuilder);
    }
}

