/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.mixin;

import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.data.PlayerDataProvider;
import tocraft.craftedcore.data.PlayerDataSynchronizer;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.registration.PlayerDataRegistry;

@Mixin(value={ServerPlayer.class})
public class ServerPlayerMixin {
    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        PlayerDataSynchronizer.sync((ServerPlayer)this);
    }

    @Inject(method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at={@At(value="RETURN")})
    private void restoreFrom(ServerPlayer serverPlayer, boolean bl, CallbackInfo ci) {
        PlayerEvents.PLAYER_RESPAWN.invoke().clone(serverPlayer, (ServerPlayer)this);
    }

    @Inject(method={"restoreFrom(Lnet/minecraft/server/level/ServerPlayer;Z)V"}, at={@At(value="TAIL")})
    private void copyPlayerData(ServerPlayer oldPlayer, boolean alive, CallbackInfo ci) {
        PlayerDataProvider oldDataProvider = (PlayerDataProvider)oldPlayer;
        PlayerDataProvider newDataProvider = (PlayerDataProvider)((Object)this);
        for (String key : oldDataProvider.craftedcore$keySet()) {
            if (!PlayerDataRegistry.isKeyPersistent(key)) continue;
            newDataProvider.craftedcore$writeTag(key, oldDataProvider.craftedcore$readTag(key));
        }
    }
}

