/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.mixin;

import net.minecraft.network.Connection;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.players.PlayerList;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.event.common.ResourceEvents;

@Mixin(value={PlayerList.class})
public class PlayerListMixin {
    @ModifyArg(method={"reloadResources()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/stats/ServerRecipeBook;sendInitialRecipeBook(Lnet/minecraft/server/level/ServerPlayer;)V"))
    private ServerPlayer endResourceReload(ServerPlayer player) {
        ResourceEvents.DATA_PACK_SYNC.invoke().onSync(player);
        return player;
    }

    @Inject(method={"placeNewPlayer(Lnet/minecraft/network/Connection;Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/server/network/CommonListenerCookie;)V"}, at={@At(value="RETURN")})
    private void placeNewPlayer(Connection connection, ServerPlayer serverPlayer, CommonListenerCookie commonListenerCookie, CallbackInfo ci) {
        PlayerEvents.PLAYER_JOIN.invoke().join(serverPlayer);
        ResourceEvents.DATA_PACK_SYNC.invoke().onSync(serverPlayer);
    }

    @Inject(method={"remove(Lnet/minecraft/server/level/ServerPlayer;)V"}, at={@At(value="HEAD")})
    private void remove(ServerPlayer serverPlayer, CallbackInfo ci) {
        PlayerEvents.PLAYER_QUIT.invoke().quit(serverPlayer);
    }
}

