/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TimerOverlayRenderer {
    public static void register(GuiGraphics graphics, int currentCooldown, int maxCooldown, Item item) {
        Minecraft client = Minecraft.getInstance();
        if (client.screen instanceof ChatScreen || currentCooldown <= 0 || item == null) {
            return;
        }
        double d = client.getWindow().getGuiScale();
        float cooldownScale = 1.0f - (float)currentCooldown / (float)maxCooldown;
        if (client.player != null) {
            int width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
            int height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            graphics.pose().pushPose();
            if (cooldownScale != 1.0f) {
                RenderSystem.enableScissor((int)((int)(0.0 * d)), (int)((int)(0.0 * d)), (int)((int)((double)width * d)), (int)((int)((double)height * (0.02 + 0.055 * (double)cooldownScale) * d)));
            }
            ItemStack stack = new ItemStack((ItemLike)item);
            graphics.renderItem(stack, (int)((float)width * 0.95f), (int)((float)height * 0.92f));
            if (cooldownScale != 1.0f) {
                RenderSystem.disableScissor();
            }
            graphics.pose().popPose();
        }
    }
}

