/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.config;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.config.Config;
import tocraft.craftedcore.config.SynchronizeStrategy;
import tocraft.craftedcore.config.annotions.Comment;
import tocraft.craftedcore.config.annotions.Synchronize;
import tocraft.craftedcore.event.client.ClientPlayerEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.craftedcore.util.JsonUtils;

public class ConfigLoader {
    public static final ResourceLocation CONFIG_SYNC = CraftedCore.id("config_sync");
    private static final Map<String, Config> LOADED_CONFIGS = new ConcurrentHashMap<String, Config>();
    private static final List<Config> CLIENT_CONFIGS = new ArrayList<Config>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private static final Gson SYNC_ONLY_GSON = new GsonBuilder().addSerializationExclusionStrategy((ExclusionStrategy)new SynchronizeStrategy()).create();

    @OnlyIn(value=Dist.CLIENT)
    public static void registerConfigSyncHandler() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, CONFIG_SYNC, ConfigLoader::handleConfigSyncPackage);
        ClientPlayerEvents.CLIENT_PLAYER_QUIT.register(player -> {
            for (Config config : CLIENT_CONFIGS) {
                for (Config potentiallySynced : LOADED_CONFIGS.values()) {
                    if (!config.getClass().getSimpleName().equals(potentiallySynced.getClass().getSimpleName())) continue;
                    boolean allConfigSyncs = Arrays.stream(config.getClass().getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize);
                    for (Field field : config.getClass().getDeclaredFields()) {
                        if (!allConfigSyncs && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) continue;
                        try {
                            field.setAccessible(true);
                            Object preSyncValue = field.get(config);
                            field.set(potentiallySynced, preSyncValue);
                        }
                        catch (IllegalAccessException e) {
                            CraftedCore.LOGGER.error("Failed reverting modifications on config {}", (Object)config.getClass().getSimpleName(), (Object)e);
                        }
                    }
                }
            }
            CLIENT_CONFIGS.clear();
        });
    }

    @SafeVarargs
    public static <C extends Config> C register(String name, C ... typeGetter) {
        Class<?> clazz = typeGetter.getClass().getComponentType();
        Object config = ConfigLoader.read(name, clazz);
        if (PlatformData.getEnv() == Dist.CLIENT) {
            PlatformData.registerConfigScreen(name);
        }
        return (C)config;
    }

    public static <C extends Config> C read(String configName, Class<C> configClass) {
        try {
            Path configFile = ConfigLoader.getConfigPath(configName);
            if (!Files.exists(configFile, new LinkOption[0])) {
                Config oldConfig;
                Path oldConfigFile = PlatformData.getConfigPath().resolve(configName + ".json");
                if (Files.exists(oldConfigFile, new LinkOption[0]) && (oldConfig = (Config)GSON.fromJson(Files.readString(oldConfigFile), configClass)) != null) {
                    ConfigLoader.writeConfigFile(configFile, oldConfig);
                    Files.delete(oldConfigFile);
                    LOADED_CONFIGS.put(configName, oldConfig);
                    return (C)oldConfig;
                }
                Config config = (Config)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigLoader.writeConfigFile(configFile, config);
                LOADED_CONFIGS.put(configName, config);
                return (C)config;
            }
            Config newConfig = (Config)GSON.fromJson(Files.readString(configFile), configClass);
            if (newConfig == null) {
                newConfig = (Config)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                CraftedCore.LOGGER.error("The Configuration '{}.json' is null. This isn't normal. It will be overwritten with default values.", (Object)configName);
            }
            ConfigLoader.writeConfigFile(configFile, newConfig);
            LOADED_CONFIGS.put(configName, newConfig);
            return (C)newConfig;
        }
        catch (Exception e) {
            CraftedCore.LOGGER.error("Failed reading config {}", (Object)configName, (Object)e);
            return null;
        }
    }

    private static <C extends Config> void writeConfigFile(Path file, C config) {
        String json = GSON.toJson(config);
        HashMap<String, String> fieldToComments = new HashMap<String, String>();
        block2: for (Field field : config.getClass().getDeclaredFields()) {
            for (Annotation annotation : field.getDeclaredAnnotations()) {
                if (!(annotation instanceof Comment)) continue;
                Comment comment = (Comment)annotation;
                fieldToComments.put(field.getName(), comment.value());
                continue block2;
            }
        }
        String jsonWithComment = JsonUtils.addComments(json, fieldToComments);
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                Files.createFile(file, new FileAttribute[0]);
            }
            Files.writeString(file, (CharSequence)jsonWithComment, new OpenOption[0]);
        }
        catch (IOException e) {
            CraftedCore.LOGGER.error("Failed saving config at {}", (Object)file, (Object)e);
        }
    }

    public static CompoundTag getConfigSyncTag(Config config) {
        CompoundTag configTag = new CompoundTag();
        if (Arrays.stream(config.getClass().getDeclaredAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) {
            configTag.putString("ConfigName", config.getClass().getSimpleName());
            configTag.putString("Serialized", GSON.toJson((Object)config));
            configTag.putBoolean("AllSync", true);
        } else {
            configTag.putString("ConfigName", config.getClass().getSimpleName());
            configTag.putString("Serialized", SYNC_ONLY_GSON.toJson((Object)config));
            configTag.putBoolean("AllSync", false);
        }
        return configTag;
    }

    public static void sendConfigSyncPackages(ServerPlayer target) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        LOADED_CONFIGS.values().forEach(config -> list.add((Object)ConfigLoader.getConfigSyncTag(config)));
        tag.put("configs", (Tag)list);
        if (!list.isEmpty()) {
            ModernNetworking.sendToPlayer(target, CONFIG_SYNC, tag);
        }
    }

    private static void handleConfigSyncPackage(ModernNetworking.Context context, CompoundTag tag) {
        CLIENT_CONFIGS.clear();
        if (tag != null && tag.contains("configs")) {
            ListTag list = (ListTag)tag.get("configs");
            if (list != null) {
                for (Tag compound : list) {
                    ConfigLoader.handleConfigTag((CompoundTag)compound);
                }
            }
        } else if (tag != null && tag.contains("ConfigName")) {
            ConfigLoader.handleConfigTag(tag);
        } else {
            CraftedCore.LOGGER.error("Failed to handle Config Sync Package.");
        }
    }

    private static void handleConfigTag(CompoundTag syncedConfiguration) {
        String name = syncedConfiguration.getString("ConfigName");
        String json = syncedConfiguration.getString("Serialized");
        boolean allSync = syncedConfiguration.getBoolean("AllSync");
        for (Config config : LOADED_CONFIGS.values()) {
            if (!config.getClass().getSimpleName().equals(name)) continue;
            Config serverConfig = (Config)GSON.fromJson(json, config.getClass());
            Config cachedClient = (Config)GSON.fromJson(GSON.toJson((Object)config), config.getClass());
            CLIENT_CONFIGS.add(cachedClient);
            for (Field field : config.getClass().getDeclaredFields()) {
                if (!allSync && !Arrays.stream(field.getAnnotations()).anyMatch(annotation -> annotation instanceof Synchronize)) continue;
                try {
                    field.setAccessible(true);
                    Object serverValue = field.get(serverConfig);
                    field.set(config, serverValue);
                }
                catch (IllegalAccessException | NullPointerException e) {
                    CraftedCore.LOGGER.error("Failed modifying config {}", (Object)config.getClass().getSimpleName(), (Object)e);
                }
            }
        }
    }

    @Nullable
    public static Config getConfigByName(String configName) {
        return LOADED_CONFIGS.get(configName);
    }

    @ApiStatus.Internal
    @NotNull
    public static Path getConfigPath(String configName) {
        return PlatformData.getConfigPath().resolve(configName + ".json5");
    }

    @ApiStatus.Internal
    public static <C extends Config> void writeConfigFile(C config) {
        ConfigLoader.writeConfigFile(ConfigLoader.getConfigPath(config.getName()), config);
    }
}

