/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore.client;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import tocraft.craftedcore.CraftedCore;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.data.PlayerDataSynchronizer;
import tocraft.craftedcore.event.client.ClientPlayerEvents;
import tocraft.craftedcore.event.client.RenderEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;

@OnlyIn(value=Dist.CLIENT)
public class CraftedCoreClient {
    private static final Set<ClientNetworking.ApplicablePacket> SYNC_PACKET_QUEUE = new HashSet<ClientNetworking.ApplicablePacket>();

    public void initialize() {
        ConfigLoader.registerConfigSyncHandler();
        PlayerDataSynchronizer.registerPacketHandler();
        ClientPlayerEvents.CLIENT_PLAYER_JOIN.register(player -> {
            for (ClientNetworking.ApplicablePacket packet : CraftedCoreClient.getSyncPacketQueue()) {
                packet.apply((Player)player);
            }
            CraftedCoreClient.getSyncPacketQueue().clear();
        });
        RenderEvents.RENDER_BREATH.register((graphics, player) -> {
            if (player != null && player.getAirSupply() == player.getMaxAirSupply() && player.isEyeInFluid(FluidTags.WATER)) {
                return InteractionResult.FAIL;
            }
            return InteractionResult.PASS;
        });
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, CraftedCore.CLEAR_CACHE_PACKET, (context, data) -> CraftedCore.clearCache());
    }

    public static Set<ClientNetworking.ApplicablePacket> getSyncPacketQueue() {
        return SYNC_PACKET_QUEUE;
    }
}

