/*
 * Decompiled with CFR 0.152.
 */
package tocraft.craftedcore;

import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.CraftedCoreCommand;
import tocraft.craftedcore.CraftedCoreConfig;
import tocraft.craftedcore.VIPs;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.data.PlayerDataSynchronizer;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.craftedcore.registration.SynchronizedReloadListenerRegistry;

public class CraftedCore {
    @ApiStatus.Internal
    public static final Logger LOGGER = LoggerFactory.getLogger(CraftedCore.class);
    @ApiStatus.Internal
    public static final Path CACHE_DIR = PlatformData.getConfigPath().resolve("craftedcore" + File.separatorChar + "cache");
    @ApiStatus.Internal
    public static final ResourceLocation CLEAR_CACHE_PACKET = CraftedCore.id("clear_cache");
    public static final String MODID = "craftedcore";
    private static boolean hasReportedNoInternet = false;

    public void initialize() {
        MixinExtrasBootstrap.init();
        ModernNetworking.registerType(ConfigLoader.CONFIG_SYNC);
        ModernNetworking.registerType(PlayerDataSynchronizer.PLAYER_DATA_SYNC_ID);
        CompletableFuture.runAsync(VIPs::cachePatreons);
        PlayerEvents.PLAYER_JOIN.register(ConfigLoader::sendConfigSyncPackages);
        PlayerEvents.PLAYER_JOIN.register(player -> {
            for (ServerPlayer serverPlayer : ((ServerLevel)CEntity.level((Entity)player)).players()) {
                PlayerDataSynchronizer.sync(serverPlayer);
            }
        });
        SynchronizedReloadListenerRegistry.initialize();
        VersionChecker.registerModrinthChecker(MODID, "crafted-core", (Component)TComponent.literal("CraftedCore"));
        ModernNetworking.registerType(CLEAR_CACHE_PACKET);
        PlayerProfile.initialize();
        CraftedCoreCommand.initialize();
        if (PlatformData.getEnv() == Dist.CLIENT) {
            PlatformData.registerConfigScreen(CraftedCoreConfig.INSTANCE.getName());
        }
    }

    public static void reportMissingInternet(Throwable cause) {
        if (!hasReportedNoInternet) {
            LOGGER.error("No internet connection!", cause);
            hasReportedNoInternet = true;
        }
    }

    @ApiStatus.Internal
    public static ResourceLocation id(String name) {
        return Identifier.parse(MODID, name);
    }

    @ApiStatus.Internal
    public static void clearCache() {
        PlayerProfile.clearCache();
        VIPs.clearCache();
        CraftedCore.forceDeleteFile(CACHE_DIR.toFile());
        CompletableFuture.runAsync(VIPs::cachePatreons);
    }

    @ApiStatus.Internal
    public static void forceDeleteFile(File element) {
        if (element.exists()) {
            File[] subFiles;
            if (element.isDirectory() && (subFiles = element.listFiles()) != null) {
                for (File sub : subFiles) {
                    CraftedCore.forceDeleteFile(sub);
                }
            }
            element.delete();
        }
    }
}

