/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.serialization.endec;

import com.mojang.datafixers.util.Either;
import io.wispforest.endec.Deserializer;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SelfDescribedDeserializer;
import io.wispforest.endec.SelfDescribedSerializer;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.Serializer;

public final class EitherEndec<L, R>
implements Endec<Either<L, R>> {
    private final Endec<L> leftEndec;
    private final Endec<R> rightEndec;
    private final boolean exclusive;

    public EitherEndec(Endec<L> leftEndec, Endec<R> rightEndec, boolean exclusive) {
        this.leftEndec = leftEndec;
        this.rightEndec = rightEndec;
        this.exclusive = exclusive;
    }

    public void encode(SerializationContext ctx, Serializer<?> serializer, Either<L, R> either) {
        if (serializer instanceof SelfDescribedSerializer) {
            either.ifLeft(left -> this.leftEndec.encode(ctx, serializer, left)).ifRight(right -> this.rightEndec.encode(ctx, serializer, right));
        } else {
            either.ifLeft(left -> {
                try (Serializer.Struct struct = serializer.struct();){
                    struct.field("is_left", ctx, Endec.BOOLEAN, (Object)true).field("left", ctx, this.leftEndec, left);
                }
            }).ifRight(right -> {
                try (Serializer.Struct struct = serializer.struct();){
                    struct.field("is_left", ctx, Endec.BOOLEAN, (Object)false).field("right", ctx, this.rightEndec, right);
                }
            });
        }
    }

    public Either<L, R> decode(SerializationContext ctx, Deserializer<?> deserializer) {
        boolean selfDescribing = deserializer instanceof SelfDescribedDeserializer;
        if (selfDescribing) {
            Either leftResult = null;
            try {
                leftResult = Either.left((Object)deserializer.tryRead(deserializer1 -> this.leftEndec.decode(ctx, deserializer1)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!this.exclusive && leftResult != null) {
                return leftResult;
            }
            Either rightResult = null;
            try {
                rightResult = Either.right((Object)deserializer.tryRead(deserializer1 -> this.rightEndec.decode(ctx, deserializer1)));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.exclusive && leftResult != null && rightResult != null) {
                throw new IllegalStateException("Both alternatives read successfully, can not pick the correct one; first: " + String.valueOf(leftResult) + " second: " + String.valueOf(rightResult));
            }
            if (leftResult != null) {
                return leftResult;
            }
            if (rightResult != null) {
                return rightResult;
            }
            throw new IllegalStateException("Neither alternative read successfully");
        }
        Deserializer.Struct struct = deserializer.struct();
        if (((Boolean)struct.field("is_left", ctx, Endec.BOOLEAN)).booleanValue()) {
            return Either.left((Object)struct.field("left", ctx, this.leftEndec));
        }
        return Either.right((Object)struct.field("right", ctx, this.rightEndec));
    }
}

