/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.mixin.ui;

import com.mojang.blaze3d.platform.Window;
import io.wispforest.owo.ui.event.ClientRenderCallback;
import io.wispforest.owo.ui.event.WindowResizeCallback;
import io.wispforest.owo.ui.util.DisposableScreen;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public class MinecraftClientMixin {
    @Unique
    private final Set<DisposableScreen> screensToDispose = new HashSet<DisposableScreen>();
    @Shadow
    @Final
    private Window window;
    @Shadow
    @Nullable
    public Screen screen;

    @Inject(method={"resizeDisplay()V"}, at={@At(value="TAIL")})
    private void captureResize(CallbackInfo ci) {
        ((WindowResizeCallback)WindowResizeCallback.EVENT.invoker()).onResized((Minecraft)this, this.window);
    }

    @Inject(method={"runTick(Z)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Window;setErrorSection(Ljava/lang/String;)V", ordinal=1)})
    private void beforeRender(boolean tick, CallbackInfo ci) {
        ((ClientRenderCallback)ClientRenderCallback.BEFORE.invoker()).onRender((Minecraft)this);
    }

    @Inject(method={"runTick(Z)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/platform/Window;updateDisplay()V", shift=At.Shift.AFTER)})
    private void afterRender(boolean tick, CallbackInfo ci) {
        ((ClientRenderCallback)ClientRenderCallback.AFTER.invoker()).onRender((Minecraft)this);
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;removed()V")})
    private void captureSetScreen(Screen screen, CallbackInfo ci) {
        Object object;
        if (screen != null && (object = this.screen) instanceof DisposableScreen) {
            DisposableScreen disposable = (DisposableScreen)object;
            this.screensToDispose.add(disposable);
        } else if (screen == null) {
            Screen screen2 = this.screen;
            if (screen2 instanceof DisposableScreen) {
                DisposableScreen disposable = (DisposableScreen)screen2;
                this.screensToDispose.add(disposable);
            }
            for (DisposableScreen disposable : this.screensToDispose) {
                try {
                    disposable.dispose();
                }
                catch (Throwable error) {
                    CrashReport report = new CrashReport("Failed to dispose screen", error);
                    report.addCategory("Screen being disposed: ").setDetail("Screen class", disposable.getClass()).setDetail("Screen being closed", (Object)this.screen).setDetail("Total screens to dispose", (Object)this.screensToDispose.size());
                    throw new ReportedException(report);
                }
            }
            this.screensToDispose.clear();
        }
    }
}

