/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config;

import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.Hook;
import io.wispforest.owo.config.annotation.Nest;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@SupportedAnnotationTypes(value={"io.wispforest.owo.config.annotation.Config"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@ApiStatus.Internal
public class ConfigAP
extends AbstractProcessor {
    private static final String WRAPPER_TEMPLATE = "package {package};\n\nimport blue.endless.jankson.Jankson;\nimport io.wispforest.owo.config.ConfigWrapper;\nimport io.wispforest.owo.config.Option;\nimport io.wispforest.owo.util.Observable;\n\nimport java.util.HashMap;\nimport java.util.Map;\nimport java.util.function.Consumer;\n\npublic class {wrapper_class_name} extends ConfigWrapper<{config_class_name}> {\n\n    public final Keys keys = new Keys();\n\n{option_instances}\n\n    private {wrapper_class_name}() {\n        super({config_class_name}.class);\n    }\n\n    private {wrapper_class_name}(Consumer<Jankson.Builder> janksonBuilder) {\n        super({config_class_name}.class, janksonBuilder);\n    }\n\n    public static {wrapper_class_name} createAndLoad() {\n        var wrapper = new {wrapper_class_name}();\n        wrapper.load();\n        return wrapper;\n    }\n\n    public static {wrapper_class_name} createAndLoad(Consumer<Jankson.Builder> janksonBuilder) {\n        var wrapper = new {wrapper_class_name}(janksonBuilder);\n        wrapper.load();\n        return wrapper;\n    }\n\n{accessors}\n\n{type_interfaces}\n\n    public static class Keys {\n{key_constants}\n    }\n}\n";
    private static final String GET_ACCESSOR_TEMPLATE = "public {field_type} {field_name}() {\n    return {option_instance}.value();\n}\n";
    private static final String SET_ACCESSOR_TEMPLATE = "public void {field_name}({field_type} value) {\n    {option_instance}.set(value);\n}\n";
    private static final String SUBSCRIBE_TEMPLATE = "public void subscribeTo{field_name}(Consumer<{field_type}> subscriber) {\n    {option_instance}.observe(subscriber);\n}\n";
    private final Set<TypeElement> nestTypes = new LinkedHashSet<TypeElement>();
    private Map<TypeMirror, TypeMirror> primitivesToWrappers;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        Types typeUtils = processingEnv.getTypeUtils();
        Elements elementUtils = processingEnv.getElementUtils();
        this.primitivesToWrappers = Map.of(typeUtils.getPrimitiveType(TypeKind.BYTE), elementUtils.getTypeElement("java.lang.Byte").asType(), typeUtils.getPrimitiveType(TypeKind.CHAR), elementUtils.getTypeElement("java.lang.Character").asType(), typeUtils.getPrimitiveType(TypeKind.SHORT), elementUtils.getTypeElement("java.lang.Short").asType(), typeUtils.getPrimitiveType(TypeKind.INT), elementUtils.getTypeElement("java.lang.Integer").asType(), typeUtils.getPrimitiveType(TypeKind.LONG), elementUtils.getTypeElement("java.lang.Long").asType(), typeUtils.getPrimitiveType(TypeKind.FLOAT), elementUtils.getTypeElement("java.lang.Float").asType(), typeUtils.getPrimitiveType(TypeKind.DOUBLE), elementUtils.getTypeElement("java.lang.Double").asType(), typeUtils.getPrimitiveType(TypeKind.BOOLEAN), elementUtils.getTypeElement("java.lang.Boolean").asType());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : annotatedElements) {
                if (element.getKind() != ElementKind.CLASS) continue;
                TypeElement clazz = (TypeElement)element;
                String className = clazz.getQualifiedName().toString();
                String wrapperName = element.getAnnotation(Config.class).wrapperName();
                try {
                    JavaFileObject file = this.processingEnv.getFiler().createSourceFile(wrapperName, new Element[0]);
                    try (PrintWriter writer = new PrintWriter(file.openWriter());){
                        writer.println(this.makeWrapper(wrapperName, className, this.collectFields(Option.Key.ROOT, clazz, clazz.getAnnotation(Config.class).defaultHook())));
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to generate config wrapper", e);
                }
            }
        }
        return true;
    }

    private List<ConfigField> collectFields(Option.Key parent, TypeElement clazz, boolean defaultHook) {
        Messager messager = this.processingEnv.getMessager();
        ArrayList<ConfigField> list = new ArrayList<ConfigField>();
        for (Element element : clazz.getEnclosedElements()) {
            if (element.getKind() != ElementKind.FIELD) continue;
            TypeMirror fieldType = element.asType();
            String fieldName = element.getSimpleName().toString();
            if (fieldType.getKind() == TypeKind.TYPEVAR) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Generic field types are not allowed in config classes");
            }
            TypeElement typeElement = null;
            if (fieldType.getKind() == TypeKind.DECLARED && (typeElement = (TypeElement)((DeclaredType)fieldType).asElement()) == clazz) {
                messager.printMessage(Diagnostic.Kind.ERROR, "Illegal self-reference in nested config object");
            }
            if (typeElement != null && element.getAnnotation(Nest.class) != null) {
                this.nestTypes.add(typeElement);
                list.add(new NestField(fieldName, this.collectFields(parent.child(fieldName), typeElement, defaultHook), typeElement.getSimpleName().toString()));
                continue;
            }
            list.add(new ValueField(fieldName, parent.child(fieldName), element.asType(), defaultHook || element.getAnnotation(Hook.class) != null));
        }
        return list;
    }

    private String makeWrapper(String wrapperClassName, String configClassName, List<ConfigField> fields) {
        String baseWrapper = WRAPPER_TEMPLATE.replace("{wrapper_class_name}", wrapperClassName).replace("{package}", configClassName.substring(0, configClassName.lastIndexOf("."))).replace("{config_class_name}", configClassName);
        Writer accessorMethods = new Writer(new StringBuilder());
        Writer optionInstances = new Writer(new StringBuilder());
        Writer keyConstants = new Writer(new StringBuilder());
        Writer typeInterfaces = new Writer(new StringBuilder());
        for (TypeElement nestType : this.nestTypes) {
            typeInterfaces.beginLine("public interface ").write(nestType.getSimpleName().toString()).endLine(" {");
            typeInterfaces.beginBlock();
            for (Element element : nestType.getEnclosedElements()) {
                if (element.getKind() != ElementKind.FIELD || element.getAnnotation(Nest.class) != null) continue;
                typeInterfaces.beginLine(element.asType().toString()).write(" ").write(element.getSimpleName().toString()).endLine("();");
                typeInterfaces.beginLine("void ").write(element.getSimpleName().toString()).write("(").write(element.asType().toString()).endLine(" value);");
            }
            typeInterfaces.endBlock();
            typeInterfaces.line("}");
        }
        keyConstants.beginBlock();
        for (ConfigField field : fields) {
            field.appendAccessors(accessorMethods, optionInstances, keyConstants);
        }
        return baseWrapper.replace("{option_instances}", optionInstances.finish()).replace("{type_interfaces}\n", typeInterfaces.finish()).replace("{key_constants}", keyConstants.finish()).replace("{accessors}\n", accessorMethods.finish());
    }

    private String makeGetAccessor(String fieldName, Option.Key fieldKey, TypeMirror fieldType) {
        return GET_ACCESSOR_TEMPLATE.replace("{option_instance}", this.constantNameOf(fieldKey)).replace("{field_name}", fieldName).replace("{field_type}", fieldType.toString());
    }

    private String makeSetAccessor(String fieldName, Option.Key fieldKey, TypeMirror fieldType) {
        return SET_ACCESSOR_TEMPLATE.replace("{option_instance}", this.constantNameOf(fieldKey)).replace("{field_name}", fieldName).replace("{field_type}", fieldType.toString());
    }

    private String makeSubscribe(String fieldName, Option.Key fieldKey, TypeMirror fieldType) {
        return SUBSCRIBE_TEMPLATE.replace("{option_instance}", this.constantNameOf(fieldKey)).replace("{field_name}", fieldName).replace("{field_type}", this.primitivesToWrappers.getOrDefault(fieldType, fieldType).toString());
    }

    private String constantNameOf(Option.Key key) {
        return key.asString().replace(".", "_");
    }

    private static String capitalize(String string) {
        return string.substring(0, 1).toUpperCase(Locale.ROOT) + string.substring(1);
    }

    private record NestField(String nestName, List<ConfigField> children, String typeName) implements ConfigField
    {
        @Override
        public void appendAccessors(Writer accessors, Writer optionInstances, Writer keyConstants) {
            Object nestClassName = ConfigAP.capitalize(this.nestName);
            if (((String)nestClassName).equals(this.typeName)) {
                nestClassName = (String)nestClassName + "_";
            }
            accessors.beginLine("public final ").write((CharSequence)nestClassName).write(" ").write(this.nestName).write(" = new ").write((CharSequence)nestClassName).endLine("();");
            accessors.beginLine("public class ").write((CharSequence)nestClassName).write(" implements ").write(this.typeName).endLine(" {");
            accessors.beginBlock();
            for (ConfigField child : this.children) {
                child.appendAccessors(accessors, optionInstances, keyConstants);
            }
            accessors.endBlock();
            accessors.line("}");
        }
    }

    private final class ValueField
    implements ConfigField {
        private final String name;
        private final Option.Key key;
        private final TypeMirror type;
        private final boolean makeSubscribe;

        private ValueField(String name, Option.Key key, TypeMirror type, boolean makeSubscribe) {
            this.name = name;
            this.key = key;
            this.type = type;
            this.makeSubscribe = makeSubscribe;
        }

        @Override
        public void appendAccessors(Writer accessors, Writer optionInstances, Writer keyConstants) {
            keyConstants.line("public final Option.Key " + ConfigAP.this.constantNameOf(this.key) + " = new Option.Key(\"" + this.key.asString() + "\");");
            optionInstances.line("private final Option<" + String.valueOf(ConfigAP.this.primitivesToWrappers.getOrDefault(this.type, this.type)) + "> " + ConfigAP.this.constantNameOf(this.key) + " = this.optionForKey(this.keys." + ConfigAP.this.constantNameOf(this.key) + ");");
            accessors.append(ConfigAP.this.makeGetAccessor(this.name, this.key, this.type)).write("\n");
            accessors.append(ConfigAP.this.makeSetAccessor(this.name, this.key, this.type)).write("\n");
            if (this.makeSubscribe) {
                accessors.append(ConfigAP.this.makeSubscribe(ConfigAP.capitalize(this.name), this.key, this.type)).write("\n");
            }
        }
    }

    private static class Writer
    implements CharSequence {
        private final StringBuilder builder;
        private int indentLevel = 1;

        private Writer(StringBuilder builder) {
            this.builder = builder;
        }

        public Writer beginLine(CharSequence text) {
            this.builder.append(" ".repeat(this.indentLevel * 4)).append(text);
            return this;
        }

        public void endLine(CharSequence text) {
            this.builder.append(text).append("\n");
        }

        public void line(CharSequence text) {
            this.builder.append("    ".repeat(this.indentLevel)).append(text).append("\n");
        }

        public Writer append(String text) {
            for (String line : text.split("\n")) {
                this.line(line);
            }
            return this;
        }

        public Writer write(CharSequence text) {
            this.builder.append(text);
            return this;
        }

        public void beginBlock() {
            ++this.indentLevel;
        }

        public void endBlock() {
            --this.indentLevel;
        }

        public String finish() {
            if (this.builder.isEmpty()) {
                return "";
            }
            if (this.builder.charAt(this.builder.length() - 1) == '\n') {
                this.builder.deleteCharAt(this.builder.length() - 1);
            }
            return this.builder.toString();
        }

        @Override
        public int length() {
            return this.builder.length();
        }

        @Override
        public char charAt(int index) {
            return this.builder.charAt(index);
        }

        @Override
        @NotNull
        public CharSequence subSequence(int start, int end) {
            return this.builder.subSequence(start, end);
        }

        @Override
        @NotNull
        public String toString() {
            return this.builder.toString();
        }
    }

    private static interface ConfigField {
        public void appendAccessors(Writer var1, Writer var2, Writer var3);
    }
}

