/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.kleeslabs.converter;

import java.util.Optional;
import net.blay09.mods.kleeslabs.converter.VerticalSlabConverter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NemosVerticalSlabConverter
implements VerticalSlabConverter {
    @Override
    public BlockState getSingleSlab(BlockState state, Level level, BlockPos pos, Player player, Direction direction) {
        if (direction.getAxis() == Direction.Axis.Y) {
            return state;
        }
        return this.locateProperty(state, "type").flatMap(property -> this.withLocateValue(state, (Property)property, NemosVerticalSlabConverter.getVerticalSlabType(direction))).orElse(state);
    }

    private static String getVerticalSlabType(Direction direction) {
        return switch (direction) {
            case Direction.SOUTH -> "front";
            case Direction.NORTH -> "back";
            case Direction.WEST -> "right";
            case Direction.EAST -> "left";
            default -> throw new IllegalArgumentException();
        };
    }

    private <T extends Comparable<T>> Optional<BlockState> withLocateValue(BlockState state, Property<T> property, String valueName) {
        return property.getValue(valueName).map(value -> (BlockState)state.setValue(property, value));
    }

    private Optional<Property<?>> locateProperty(BlockState state, String name) {
        for (Property property : state.getProperties()) {
            if (!property.getName().equals(name) || !StringRepresentable.class.isAssignableFrom(property.getValueClass())) continue;
            return Optional.of(property);
        }
        return Optional.empty();
    }

    @Override
    public boolean isDoubleSlab(BlockState state) {
        return this.locateProperty(state, "type").map(arg_0 -> ((BlockState)state).getValue(arg_0)).map(value -> ((StringRepresentable)value).getSerializedName()).map(name -> name.equals("double")).orElse(false);
    }
}

