/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.renderer;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltipClient;
import com.misterpemodder.shulkerboxtooltip.api.PreviewContext;
import com.misterpemodder.shulkerboxtooltip.api.PreviewType;
import com.misterpemodder.shulkerboxtooltip.api.config.PreviewConfiguration;
import com.misterpemodder.shulkerboxtooltip.api.provider.EmptyPreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.provider.PreviewProvider;
import com.misterpemodder.shulkerboxtooltip.api.renderer.PreviewRenderer;
import com.misterpemodder.shulkerboxtooltip.impl.util.MergedItemStack;
import com.misterpemodder.shulkerboxtooltip.impl.util.ShulkerBoxTooltipUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BasePreviewRenderer
implements PreviewRenderer {
    protected PreviewType previewType;
    protected PreviewConfiguration config;
    protected int compactMaxRowSize;
    protected int maxRowSize = 9;
    protected ResourceLocation textureOverride;
    protected PreviewProvider provider;
    protected List<MergedItemStack> items = new ArrayList<MergedItemStack>();
    protected PreviewContext previewContext;
    private final int slotWidth;
    private final int slotHeight;
    private final int slotXOffset;
    private final int slotYOffset;

    protected BasePreviewRenderer(int slotWidth, int slotHeight, int slotXOffset, int slotYOffset) {
        this.previewType = PreviewType.FULL;
        this.slotWidth = slotWidth;
        this.slotHeight = slotHeight;
        this.slotXOffset = slotXOffset;
        this.slotYOffset = slotYOffset;
        ClientLevel world = ShulkerBoxTooltipClient.client == null ? null : ShulkerBoxTooltipClient.client.level;
        this.setPreview(PreviewContext.builder(ItemStack.EMPTY).withRegistryLookup((HolderLookup.Provider)(world == null ? null : world.registryAccess())).build(), EmptyPreviewProvider.INSTANCE);
    }

    protected int getMaxRowSize() {
        return this.previewType == PreviewType.COMPACT ? this.compactMaxRowSize : this.maxRowSize;
    }

    protected int getInvSize() {
        return this.previewType == PreviewType.COMPACT ? Math.max(1, this.items.size()) : this.provider.getInventoryMaxSize(this.previewContext);
    }

    @Override
    public void setPreviewType(PreviewType type) {
        this.previewType = type;
    }

    @Override
    public void setPreview(PreviewContext context, PreviewProvider provider) {
        List<ItemStack> inventory = provider.getInventory(context);
        int rowSize = provider.getMaxRowSize(context);
        this.config = context.config();
        this.compactMaxRowSize = this.config.defaultMaxRowSize();
        if (this.compactMaxRowSize <= 0) {
            this.compactMaxRowSize = 9;
        }
        if (rowSize <= 0) {
            rowSize = this.compactMaxRowSize;
        }
        this.maxRowSize = rowSize;
        this.textureOverride = provider.getTextureOverride(context);
        this.provider = provider;
        this.items = MergedItemStack.mergeInventory(inventory, provider.getInventoryMaxSize(context), this.config.itemStackMergingStrategy());
        this.previewContext = context;
    }

    private int getSlotAt(int x, int y) {
        int slot = -1;
        if (x + 1 >= this.slotXOffset && y + 1 >= this.slotYOffset) {
            int maxRowSize = this.getMaxRowSize();
            int slotX = (x + 1 - this.slotXOffset) / this.slotWidth;
            int slotY = (y + 1 - this.slotYOffset) / this.slotHeight;
            if (slotX < maxRowSize) {
                slot = slotX + slotY * maxRowSize;
            }
        }
        return slot;
    }

    private ItemStack getStackAt(int x, int y) {
        int slot = this.getSlotAt(x, y);
        if (this.previewType == PreviewType.COMPACT) {
            if (slot < 0 || slot >= this.items.size()) {
                return ItemStack.EMPTY;
            }
            MergedItemStack merged = this.items.get(slot);
            return merged == null ? ItemStack.EMPTY : merged.get();
        }
        for (MergedItemStack merged : this.items) {
            ItemStack stack = merged.getSubStack(slot);
            if (stack.isEmpty()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private void drawItem(ItemStack stack, int x, int y, GuiGraphics graphics, Font font, int slot, boolean shortItemCount) {
        String countLabel = "";
        int maxRowSize = this.getMaxRowSize();
        if (stack.getCount() != 1) {
            countLabel = shortItemCount ? ShulkerBoxTooltipUtil.abbreviateInteger(stack.getCount()) : String.valueOf(stack.getCount());
        }
        x = this.slotXOffset + x + this.slotWidth * (slot % maxRowSize);
        y = this.slotYOffset + y + this.slotHeight * (slot / maxRowSize);
        graphics.renderItem(stack, x, y);
        graphics.renderItemDecorations(font, stack, x, y, countLabel);
    }

    protected void drawItems(int x, int y, GuiGraphics graphics, Font font) {
        if (this.previewType == PreviewType.COMPACT) {
            boolean shortItemCounts = this.config.shortItemCounts();
            int size = this.items.size();
            for (int slot = 0; slot < size; ++slot) {
                this.drawItem(this.items.get(slot).get(), x, y, graphics, font, slot, shortItemCounts);
            }
        } else {
            for (MergedItemStack compactor : this.items) {
                int size = compactor.size();
                for (int slot = 0; slot < size; ++slot) {
                    this.drawItem(compactor.getSubStack(slot), x, y, graphics, font, slot, false);
                }
            }
        }
    }

    protected void drawInnerTooltip(int x, int y, GuiGraphics graphics, Font font, int mouseX, int mouseY) {
        ItemStack stack = this.getStackAt(mouseX - x, mouseY - y);
        if (!stack.isEmpty()) {
            graphics.renderTooltip(font, stack, mouseX, mouseY);
        }
    }

    protected void drawSlotHighlight(int x, int y, GuiGraphics graphics, int mouseX, int mouseY) {
        int slot = this.getSlotAt(mouseX - x, mouseY - y);
        if (slot >= 0 && slot < this.getInvSize()) {
            int maxRowSize = this.getMaxRowSize();
            x = this.slotXOffset + x + this.slotWidth * (slot % maxRowSize);
            y = this.slotYOffset + y + this.slotHeight * (slot / maxRowSize);
            AbstractContainerScreen.renderSlotHighlight((GuiGraphics)graphics, (int)x, (int)y, (int)0);
        }
    }
}

