/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry;

import com.misterpemodder.shulkerboxtooltip.impl.config.gui.ConfigCategoryTab;
import com.misterpemodder.shulkerboxtooltip.impl.config.gui.entry.ValueConfigEntry;
import com.misterpemodder.shulkerboxtooltip.impl.tree.ValueConfigNode;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class EnumValueConfigEntry<C, E extends Enum<E>>
extends ValueConfigEntry<C, E, E> {
    private final CycleButton<E> valueButton;

    public EnumValueConfigEntry(ConfigCategoryTab<C> tab, ValueConfigNode<C, E, E> valueNode) {
        super(tab, valueNode);
        this.valueButton = CycleButton.builder(value -> Component.translatable((String)value.toString())).displayOnlyValue().withValues(List.of((Enum[])this.valueNode.getValueType().getEnumConstants())).withInitialValue((Object)((Enum)this.getValue())).create(0, 0, 160, 20, this.valueNode.getTitle(), (b, value) -> this.setValue(value));
        this.children.addFirst(this.valueButton);
    }

    @Override
    public void refresh() {
        super.refresh();
        Enum value = (Enum)this.getValue();
        if (this.valueButton.getValue() != value) {
            this.valueButton.setValue((Object)value);
        }
    }

    public void render(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
        this.renderLabel(guiGraphics, x, y, entryWidth);
        this.valueButton.setWidth(160 - this.resetButton.getWidth() - 2 - this.undoButton.getWidth() - 2);
        if (this.tab.getMinecraft().font.isBidirectional()) {
            this.undoButton.setX(x);
            this.undoButton.setY(y);
            this.resetButton.setX(x + this.undoButton.getWidth() + 2);
            this.resetButton.setY(y);
            this.valueButton.setX(x + this.undoButton.getWidth() + 2 + this.resetButton.getWidth() + 2);
            this.valueButton.setY(y);
        } else {
            this.undoButton.setX(x + entryWidth - this.undoButton.getWidth());
            this.undoButton.setY(y);
            this.resetButton.setX(this.undoButton.getX() - this.resetButton.getWidth() - 2);
            this.resetButton.setY(y);
            this.valueButton.setX(this.resetButton.getX() - this.valueButton.getWidth() - 2);
            this.valueButton.setY(y);
        }
        this.valueButton.render(guiGraphics, mouseX, mouseY, delta);
        this.resetButton.render(guiGraphics, mouseX, mouseY, delta);
        this.undoButton.render(guiGraphics, mouseX, mouseY, delta);
    }
}

