/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.components.WorldPos;
import com.tom.storagemod.inventory.IInventoryLink;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.saveddata.SavedData;

public class RemoteConnections
extends SavedData {
    private static final String CONNECTIONS_TAG = "connections";
    public static final String CHANNEL_ID = "id";
    public static final String OWNER_ID = "owner";
    public static final String PUBLIC_TAG = "public";
    public static final String DISPLAY_NAME = "name";
    private static final String ID = "toms_storage_rc";
    private static final SavedData.Factory<RemoteConnections> FACTORY = new SavedData.Factory(RemoteConnections::new, RemoteConnections::new, DataFixTypes.LEVEL);
    public static final String OWNER_NAME = "owner_name";
    private Map<UUID, Channel> connections = new HashMap<UUID, Channel>();

    private RemoteConnections() {
    }

    private RemoteConnections(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = tag.getList(CONNECTIONS_TAG, 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag t = list.getCompound(i);
            UUID channel = t.getUUID(CHANNEL_ID);
            this.connections.put(channel, new Channel(t));
        }
    }

    public static RemoteConnections get(Level world) {
        ServerLevel sw = (ServerLevel)world;
        return (RemoteConnections)sw.getServer().overworld().getDataStorage().computeIfAbsent(FACTORY, ID);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.connections.forEach((k, v) -> {
            CompoundTag t = new CompoundTag();
            t.putUUID(CHANNEL_ID, k);
            v.save(t);
            list.add((Object)t);
        });
        tag.put(CONNECTIONS_TAG, (Tag)list);
        return tag;
    }

    public Channel getChannel(UUID connection) {
        return this.connections.get(connection);
    }

    public UUID makeChannel(String name, boolean isPublic, Player owner) {
        UUID id = UUID.randomUUID();
        if (((String)name).isEmpty() || ((String)name).length() > 50) {
            name = "Channel " + System.currentTimeMillis();
        }
        this.connections.put(id, new Channel(owner.getGameProfile().getId(), owner.getGameProfile().getName(), isPublic, (String)name));
        this.setDirty();
        return id;
    }

    public void removeChannel(UUID id, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            this.connections.remove(id);
            this.setDirty();
        }
    }

    public void editChannel(UUID id, boolean pub, UUID player) {
        Channel c = this.connections.get(id);
        if (c != null && c.owner.equals(player)) {
            c.publicChannel = pub;
            this.setDirty();
        }
    }

    public void invalidateCache(UUID id) {
        Channel c = this.connections.get(id);
        if (c != null) {
            c.connectors.clear();
        }
    }

    public Stream<Map.Entry<UUID, Channel>> streamChannels(Player player) {
        return this.connections.entrySet().stream().filter(c -> ((Channel)c.getValue()).canAccess(player));
    }

    public static class Channel {
        public Set<WorldPos> connectors = new HashSet<WorldPos>();
        public UUID owner;
        public String ownerName;
        public boolean publicChannel;
        public String displayName;

        public Channel(UUID owner, String ownerName, boolean publicChannel, String displayName) {
            this.owner = owner;
            this.ownerName = ownerName;
            this.publicChannel = publicChannel;
            this.displayName = displayName;
        }

        private Channel(CompoundTag t) {
            this(t.getUUID(RemoteConnections.OWNER_ID), t.getString(RemoteConnections.OWNER_NAME), t.getBoolean(RemoteConnections.PUBLIC_TAG), t.getString(RemoteConnections.DISPLAY_NAME));
        }

        public void register(ServerLevel world, BlockPos blockPos) {
            WorldPos pos = new WorldPos((ResourceKey<Level>)world.dimension(), blockPos);
            this.connectors.add(pos);
        }

        public Set<IInventoryLink> findOthers(ServerLevel world, BlockPos blockPos, int lvl) {
            WorldPos pos = new WorldPos((ResourceKey<Level>)world.dimension(), blockPos);
            this.connectors.add(pos);
            HashSet<IInventoryLink> found = new HashSet<IInventoryLink>();
            Iterator<WorldPos> posItr = this.connectors.iterator();
            while (posItr.hasNext()) {
                WorldPos dimPos = posItr.next();
                if (dimPos.equals(pos)) continue;
                BlockEntity te = dimPos.getBlockEntity(world);
                if (te instanceof IInventoryLink) {
                    IInventoryLink link = (IInventoryLink)te;
                    if (!link.isAccessibleFrom(world, blockPos, lvl)) continue;
                    found.add(link);
                    continue;
                }
                posItr.remove();
            }
            return found;
        }

        public void save(CompoundTag t) {
            t.putUUID(RemoteConnections.OWNER_ID, this.owner);
            t.putBoolean(RemoteConnections.PUBLIC_TAG, this.publicChannel);
            t.putString(RemoteConnections.DISPLAY_NAME, this.displayName);
            t.putString(RemoteConnections.OWNER_NAME, this.ownerName);
        }

        public boolean canAccess(Player player) {
            return this.publicChannel || this.owner.equals(player.getUUID());
        }
    }
}

