/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.inventory;

import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.WorldStates;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class InventoryCableNetwork {
    private final Level level;
    private Map<BlockPos, CableCache> caches = new HashMap<BlockPos, CableCache>();

    public InventoryCableNetwork(Level level) {
        this.level = level;
    }

    public Collection<BlockPos> getNetworkNodes(BlockPos from) {
        CableCache cache = this.caches.get(from);
        if (cache != null) {
            return cache.attached;
        }
        HashSet<BlockPos> checked = new HashSet<BlockPos>();
        Stack<BlockFace> next = new Stack<BlockFace>();
        HashSet<BlockPos> cables = new HashSet<BlockPos>();
        HashSet<BlockPos> attached = new HashSet<BlockPos>();
        next.add(new BlockFace(from, null));
        while (!next.isEmpty()) {
            BlockState st;
            Block block;
            BlockFace p2 = (BlockFace)next.pop();
            if (checked.contains(p2.pos())) continue;
            checked.add(p2.pos());
            if (!this.level.isLoaded(p2.pos()) || !((block = (st = this.level.getBlockState(p2.pos())).getBlock()) instanceof IInventoryCable)) continue;
            IInventoryCable c = (IInventoryCable)block;
            if (p2.from() != null && !c.canConnectFrom(st, p2.from())) continue;
            CableCache cc = this.caches.get(p2.pos());
            if (cc != null) {
                cables.addAll(cc.cables);
                attached.addAll(cc.attached);
                checked.addAll(cc.cables);
                continue;
            }
            if (c.isFunctionalNode()) {
                attached.add(p2.pos());
            } else {
                cables.add(p2.pos());
            }
            next.addAll(c.nextScan(this.level, st, p2.pos()));
        }
        CableCache cc = new CableCache(cables, attached);
        cables.forEach(p -> this.caches.put((BlockPos)p, cc));
        return cc.attached;
    }

    public void markNodeInvalid(BlockPos pos) {
        CableCache cc = this.caches.get(pos);
        if (cc != null) {
            cc.cables.forEach(this.caches::remove);
        }
    }

    public void markNodeInvalid(BlockFace pos) {
        this.markNodeInvalid(pos.pos());
    }

    public static InventoryCableNetwork getNetwork(Level level) {
        return WorldStates.cableNetworks.computeIfAbsent(level, InventoryCableNetwork::new);
    }

    private record CableCache(Set<BlockPos> cables, Set<BlockPos> attached) {
    }
}

