/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.mojang.serialization.MapCodec;
import com.tom.storagemod.Config;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.block.InventoryCableBlock;
import com.tom.storagemod.block.NeoForgeBlock;
import com.tom.storagemod.block.entity.InventoryCableConnectorBlockEntity;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.TickerUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class InventoryCableConnectorBlock
extends BaseEntityBlock
implements IInventoryCable,
NeoForgeBlock {
    public static final BooleanProperty UP = BlockStateProperties.UP;
    public static final BooleanProperty DOWN = BlockStateProperties.DOWN;
    public static final BooleanProperty NORTH = BlockStateProperties.NORTH;
    public static final BooleanProperty SOUTH = BlockStateProperties.SOUTH;
    public static final BooleanProperty EAST = BlockStateProperties.EAST;
    public static final BooleanProperty WEST = BlockStateProperties.WEST;
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    private static final Direction[] FACING_VALUES = Direction.values();
    protected VoxelShape[][] shapes = this.makeShapes(0.125f);
    public static final MapCodec<InventoryCableConnectorBlock> CODEC = ChestBlock.simpleCodec(properties -> new InventoryCableConnectorBlock());

    public InventoryCableConnectorBlock() {
        this(false);
    }

    protected InventoryCableConnectorBlock(boolean dummy) {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(3.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)DOWN, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.DOWN));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ClientUtil.tooltip("inventory_cable_connector", tooltip, new Object[0]);
        if (Config.get().invLinkBeaconLvl != -1) {
            ClientUtil.tooltip("inventory_cable_connector_link.beacon", false, tooltip, new Object[0]);
            ClientUtil.tooltip("inventory_cable_connector_link.beacon0", false, tooltip, Config.get().invLinkBeaconLvl, Config.get().invLinkBeaconRange);
            if (Config.get().invLinkBeaconLvlSameDim != -1) {
                ClientUtil.tooltip("inventory_cable_connector_link.beacon1", false, tooltip, Config.get().invLinkBeaconLvlSameDim);
            }
            if (Config.get().invLinkBeaconLvlCrossDim != -1) {
                ClientUtil.tooltip("inventory_cable_connector_link.beacon2", false, tooltip, Config.get().invLinkBeaconLvlCrossDim);
            }
            ClientUtil.tooltip("inventory_cable_connector_link", false, tooltip, new Object[0]);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new InventoryCableConnectorBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, DOWN, NORTH, SOUTH, EAST, WEST, FACING});
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        Direction f = (Direction)stateIn.getValue((Property)FACING);
        if (facing == f) {
            return (BlockState)stateIn.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(!facingState.isAir()));
        }
        return (BlockState)stateIn.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(facing), (Comparable)Boolean.valueOf(IInventoryCable.canConnect(facingState, facing)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.withConnectionProperties((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite()), (LevelAccessor)context.getLevel(), context.getClickedPos());
    }

    @Override
    public boolean canConnectFrom(BlockState state, Direction dir) {
        return state.getValue((Property)FACING) != dir;
    }

    @Override
    public List<BlockFace> nextScan(Level world, BlockState state, BlockPos pos) {
        Direction f = (Direction)state.getValue((Property)FACING);
        ArrayList<BlockFace> next = new ArrayList<BlockFace>();
        for (Direction d : Direction.values()) {
            if (d == f || !((Boolean)state.getValue((Property)InventoryCableBlock.DIR_TO_PROPERTY[d.ordinal()])).booleanValue()) continue;
            next.add(new BlockFace(pos.relative(d), d.getOpposite()));
        }
        return next;
    }

    public BlockState withConnectionProperties(BlockState state, LevelAccessor blockView_1, BlockPos blockPos_1) {
        BlockState block_1 = blockView_1.getBlockState(blockPos_1.below());
        BlockState block_2 = blockView_1.getBlockState(blockPos_1.above());
        BlockState block_3 = blockView_1.getBlockState(blockPos_1.north());
        BlockState block_4 = blockView_1.getBlockState(blockPos_1.east());
        BlockState block_5 = blockView_1.getBlockState(blockPos_1.south());
        BlockState block_6 = blockView_1.getBlockState(blockPos_1.west());
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnect(state, block_1, Direction.DOWN)))).setValue((Property)UP, (Comparable)Boolean.valueOf(this.canConnect(state, block_2, Direction.UP)))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnect(state, block_3, Direction.NORTH)))).setValue((Property)EAST, (Comparable)Boolean.valueOf(this.canConnect(state, block_4, Direction.EAST)))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnect(state, block_5, Direction.SOUTH)))).setValue((Property)WEST, (Comparable)Boolean.valueOf(this.canConnect(state, block_6, Direction.WEST)));
    }

    private boolean canConnect(BlockState state, BlockState block, Direction dir) {
        Direction f = (Direction)state.getValue((Property)FACING);
        return dir != f && IInventoryCable.canConnect(block, dir) || dir == f && !block.isAir();
    }

    public BlockState rotate(BlockState blockState_1, Rotation blockRotation_1) {
        switch (blockRotation_1) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.setValue((Property)NORTH, (Comparable)((Boolean)blockState_1.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)blockState_1.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState_1.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)blockState_1.getValue((Property)EAST)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.setValue((Property)NORTH, (Comparable)((Boolean)blockState_1.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)blockState_1.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState_1.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState_1.getValue((Property)NORTH)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)blockState_1.setValue((Property)NORTH, (Comparable)((Boolean)blockState_1.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)blockState_1.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState_1.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState_1.getValue((Property)SOUTH)));
            }
        }
        return blockState_1;
    }

    public BlockState mirror(BlockState blockState_1, Mirror blockMirror_1) {
        switch (blockMirror_1) {
            case FRONT_BACK: {
                return (BlockState)((BlockState)blockState_1.setValue((Property)NORTH, (Comparable)((Boolean)blockState_1.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)blockState_1.getValue((Property)NORTH)));
            }
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)blockState_1.setValue((Property)EAST, (Comparable)((Boolean)blockState_1.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)blockState_1.getValue((Property)EAST)));
            }
        }
        return super.mirror(blockState_1, blockMirror_1);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[((Direction)state.getValue((Property)FACING)).ordinal()][this.getShapeIndex(state)];
    }

    protected int getShapeIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (!((Boolean)state.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(FACING_VALUES[j]))).booleanValue()) continue;
            i |= 1 << j;
        }
        return i;
    }

    private VoxelShape[][] makeShapes(float apothem) {
        float f = 0.5f - apothem;
        float f1 = 0.5f + apothem;
        VoxelShape voxelshape = Block.box((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        VoxelShape[] avoxelshape = new VoxelShape[FACING_VALUES.length];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            avoxelshape[i] = Shapes.box((double)(0.5 + Math.min((double)(-apothem), (double)direction.getStepX() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.getStepY() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.getStepZ() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.getStepX() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.getStepY() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.getStepZ() * 0.5)));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < FACING_VALUES.length; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = Shapes.or((VoxelShape)voxelshape1, (VoxelShape)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        VoxelShape[][] ret = new VoxelShape[6][64];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            VoxelShape s = Shapes.or((VoxelShape)InventoryCableConnectorBlock.createShape(direction, 16.0f, 0.0f, 16.0f, 0.0f, 2.0f, 0.0f), (VoxelShape[])new VoxelShape[]{InventoryCableConnectorBlock.createShape(direction, 10.0f, 3.0f, 10.0f, 3.0f, 2.0f, 2.0f), InventoryCableConnectorBlock.createShape(direction, 6.0f, 5.0f, 6.0f, 5.0f, 2.0f, 4.0f)});
            for (int j = 0; j < avoxelshape1.length; ++j) {
                ret[i][j] = Shapes.or((VoxelShape)avoxelshape1[j], (VoxelShape)s);
            }
        }
        return ret;
    }

    private static VoxelShape createShape(Direction dir, float width, float widthoff, float height, float heightoff, float depth, float depthoff) {
        switch (dir) {
            case DOWN: {
                return InventoryCableConnectorBlock.box(heightoff, depthoff, widthoff, height + heightoff, depth + depthoff, width + widthoff);
            }
            case EAST: {
                return InventoryCableConnectorBlock.box(16.0f - depth, heightoff, widthoff, 16.0f - depthoff, height + heightoff, width + widthoff);
            }
            case NORTH: {
                return InventoryCableConnectorBlock.box(widthoff, heightoff, depthoff, width + widthoff, height + heightoff, depth + depthoff);
            }
            case SOUTH: {
                return InventoryCableConnectorBlock.box(widthoff, heightoff, 16.0f - depth, width + widthoff, height + heightoff, 16.0f - depthoff);
            }
            case UP: {
                return InventoryCableConnectorBlock.box(heightoff, 16.0f - depth, widthoff, height + heightoff, 16.0f - depthoff, width + widthoff);
            }
            case WEST: {
                return InventoryCableConnectorBlock.box(depthoff, heightoff, widthoff, depth + depthoff, height + heightoff, width + widthoff);
            }
        }
        return Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public static VoxelShape box(double xMin, double yMin, double zMin, double xMax, double yMax, double zMax) {
        return Block.box((double)Math.min(xMin, xMax), (double)Math.min(yMin, yMax), (double)Math.min(zMin, zMax), (double)Math.max(xMin, xMax), (double)Math.max(yMin, yMax), (double)Math.max(zMin, zMax));
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        InventoryCableConnectorBlockEntity be;
        BlockEntity blockEntity_1 = world.getBlockEntity(pos);
        if (blockEntity_1 instanceof InventoryCableConnectorBlockEntity && (be = (InventoryCableConnectorBlockEntity)blockEntity_1).hasBeacon()) {
            if (world.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            if (be.stillValid(player)) {
                player.openMenu((MenuProvider)be);
                return InteractionResult.SUCCESS;
            }
            player.displayClientMessage((Component)Component.translatable((String)"chat.toms_storage.inv_link_access_denied"), true);
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void destroy(LevelAccessor p_49860_, BlockPos p_49861_, BlockState p_49862_) {
        if (p_49860_ instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)p_49860_;
            InventoryCableNetwork.getNetwork((Level)l).markNodeInvalid(p_49861_);
        }
    }

    public void neighborChanged(BlockState p_60509_, Level p_60510_, BlockPos p_60511_, Block p_60512_, BlockPos p_60513_, boolean p_60514_) {
        super.neighborChanged(p_60509_, p_60510_, p_60511_, p_60512_, p_60513_, p_60514_);
        if (!p_60510_.isClientSide) {
            InventoryCableNetwork n = InventoryCableNetwork.getNetwork(p_60510_);
            n.markNodeInvalid(p_60511_);
            n.markNodeInvalid(p_60513_);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            InventoryCableNetwork n = InventoryCableNetwork.getNetwork((Level)l);
            n.markNodeInvalid(pos);
            n.markNodeInvalid(neighbor);
        }
    }
}

